var EXPORTED_SYMBOLS = ["filterButton"];

var categoryManager = Components.classes["@mozilla.org/categorymanager;1"]
                      .getService(Components.interfaces.nsICategoryManager);

var filterButton = {
  // It needs to be added to the category in the mainfest for some reason,
  // so the filter starts enabled. However, this makes the CategoryManager
  // actually work.
  filter: true,
  btn: null,

  init: function(btn) {
    this.btn = btn;
    // Since it defaults on, we should turn it off.
    this.toggle();
    this.refresh();
  },

  refresh: function() {
    if (this.filter) {
      this.btn.image = "chrome://cfbuilder/content/icons/other/dialog-warning.png";
      this.btn.setAttribute("tooltiptext", "Content filter: enabled; click to toggle");
    } else {
      this.btn.image = "chrome://cfbuilder/content/icons/system-log-out.png";
      this.btn.setAttribute("tooltiptext", "Content filter: disabled; click to toggle");
    }
  },

  toggle: function() {
    if (this.filter) {
      categoryManager.deleteCategoryEntry("content-policy", "ContentFilter", false);
    } else {
      categoryManager.addCategoryEntry("content-policy", "ContentFilter", "@indexdata.com/contentfilter;1", false, true);
    }
    this.filter = !this.filter;
    this.refresh();
  }
};
