#!/bin/sh
#
# create pp2 target config cf.xml
#
# usage: create-pp2-targets.sh [connectors]
#
# usage: create-pp2-targets.sh ../../connectors/[a-d]*.cf
# usage: create-pp2-targets.sh  amazon-com pica-gbv


CF_BASE_PATH=`cd ../..; pwd`
if test -z "$1"; then
	FILES=$CF_BASE_PATH/connectors/*.cf
else
	FILES="$@"
fi

# which ports cfzserver should use
: ${CFZSERVER_PORT="8999"}

# which cfzserver host should use
: ${CFZSERVER_HOSTNAME="recv.de"}


for i in `echo $FILES | perl -npe 's/\s+/\n/g'`
do
    file=`echo $i | perl -npe 's,.*/,,; s,\.cf$,,; '`

    # extract the full name of the database from the connector meta data
    name=`perl -ne 'print "$1\n" if m,<meta name="title" content="(.*?)"/>,' $i`
    test -z "$name" && name=$file

    echo "<set target=\"$CFZSERVER_HOSTNAME:$CFZSERVER_PORT/$file\" name=\"pz:name\" value=\"$name\" />"
done
