// prefs.js, production settings

// Try to run headless
// Still needs an X server, xvfb is fine. 
//pref("toolkit.defaultChromeURI", "");
// See http://blog.techno-barje.fr/post/2009/09/30/Headless-xulrunner
// does not help


// Levels supported: DEBUG, INFO, WARN, ERROR
user_pref("indexdata.cf.logging.root", "WARN");

// disable auto-update
user_pref("app.update.enabled", false);
user_pref("app.update.auto", false);

//disable image loading
user_pref("permissions.default.image", 2);

//
// see cf/engine/PROXY for more information about proxy configuration
//
// user_pref("network.proxy.http", "localhost"); user_pref("network.proxy.http_port", 3128); user_pref("network.proxy.type", 1);
//
// $ ssh ssh -vD 1080 hostname
// user_pref("network.proxy.socks", "localhost"); user_pref("network.proxy.socks_port", 1080); user_pref("network.proxy.type", 1);

// user_pref("network.proxy.autoconfig_url", "http://us2.indexdata.com:9005/id/cf.pac"); user_pref("network.proxy.type", 2);
// user_pref("network.proxy.autoconfig_url", "file:///home/wosch/indexdata/cf/engine/src/cf.pac"); user_pref("network.proxy.type", 2);

//disable javascript
// user_pref("javascript.enabled", false);

// disable java
user_pref("security.enable_java", false);

// disable favicon fetching
user_pref("browser.chrome.favicons", false);
user_pref("browser.chrome.site_icons", false);

user_pref("network.http.pipelining", false);

// more connections
user_pref("network.http.max-connections", 96);
user_pref("network.http.max-connections-per-server", 32);
user_pref("network.http.max-persistent-connections-per-server", 6);

// don't be shy about opening new ones
user_pref("network.http.request.max-start-delay", 0);

// reflow periodically instead of every time new data received
user_pref("content.notify.ontimer", true);

// set the timer so that no reflow is done until the final one once content loaded
user_pref("content.notify.backoffcount", 0);

// and try and avoid rendering anything before you've got it
user_pref("nglayout.initialpaint.delay", 3000000);

// don't listen for interrupts when parsing
user_pref("content.interrupt.parsing", false);

// don't bother with image placeholders
user_pref("browser.display.show_image_placeholders", false);

// disable checking phishing lists
user_pref("browser.safebrowsing.enabled", false);

// disable any attempt to pre-fetch links
user_pref("network.prefetch-next", false);

// disable double buffering
user_pref("viewmanager.do_doublebuffering", false);

// disable antialiasing
user_pref("font.antialias.min", 100000);

// disable disk caching at all
user_pref("browser.cache.disk.enable", false);
user_pref("browser.cache.offline.enable", false);
user_pref("browser.cache.disk.capacity", 0);
user_pref("browser.cache.offline.capacity", 0);
user_pref("browser.cache.disk_cache_ssl", false);

// enable memory cache (default)
// user_pref("browser.cache.memory.enable", true);

