var EXPORTED_SYMBOLS = ["ForEach"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/runtime/Block.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');
Components.utils.import('resource://indexdata/thirdparty/jsonPath.js');
Components.utils.import('resource://indexdata/util/logging.js');

var logger = logging.getLogger();
var ForEach = function () { this.conf = {}; };
ForEach.prototype = new Step();
ForEach.prototype.constructor = ForEach;

ForEach.prototype.init = function(task) {
  //this is ugly but we need to check if the blocks exist in that instance
  if (this.blocks.length == 0) {
    this.blocks.push(new Block(task, 'do', 'do', this));
  }
};

ForEach.prototype.draw = function(surface) {
  let sourceBox = xulHelper.jsonPathField(surface, this, this.conf, 'source', "Iterate through objects matching path (key ignored): ");
  let currentBox = xulHelper.jsonPathField(surface, this, this.conf, 'current', "Store current object: ", {path: '$.temp', key: 'current'});
};

ForEach.prototype.run = function (task, block) {
  let objs = jsonPath(task.data, this.conf.source.path);
  let dest = jsonPath(task.data, this.conf.current.path)[0];
  for (let i = 0; i < objs.length; i++) {
    dest[this.conf.current.key] = [objs[i]];
    this.blocks[0].run(block);
  }
};

ForEach.prototype.getClassName = function () { return "ForEach"; };
ForEach.prototype.getDisplayName = function () { return "For each"; };
ForEach.prototype.getDescription = function () {
  return "Iterate through a list of objects";
};

ForEach.prototype.getVersion = function () {
  return "1.0";
};

ForEach.prototype.getUsedArgs = function () {
   return [];
}

ForEach.prototype.renderArgs = function () {
  return this.conf.source ? this.conf.source.path + '.' + this.conf.source.key + " -> " + this.conf.current.path  + '.' + this.conf.current.key : "";
};
