/**
 * \file cfhello.cpp
 * \brief Simple use of CF_Engine
 */
#include <stdio.h>
#include <stdlib.h>
#include "cf_engine.h"

int main(int argc, char **argv)
{
    if (argc < 4)
    {
	printf("cfhello cffile task args\n");
	return 1;
    }
    try
    {
        CF_Engine e(CF_Engine::FORK, getenv("CF_MODULE_PATH"), 0, 0, 0, 0,
                    0 /* TODO: LOGGER */, -1);
	e.load_cf(argv[1]);

	const char *result = 0;
	e.run_task(argv[2], argv[3], &result);
	if (result)
	    printf("Got result %s\n", result);
    }
    catch (CF_Engine_Error &e) {
	printf("CF Error %s\n", e.what());
    }
    catch (...) {
	printf("Unknown Exception\n");
    }
    return 0;
}
/*
 * Local variables:
 * c-basic-offset: 4
 * c-file-style: "Stroustrup"
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=4 tabstop=8 expandtab
 */

