var EXPORTED_SYMBOLS = ["NormalizeNumber"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');
Components.utils.import("resource://indexdata/util/logging.js");

var NormalizeNumber = function () {
  this.conf = {
    "in": undefined,
    out: undefined,
  };
};
NormalizeNumber.prototype = new Step();
NormalizeNumber.prototype.constructor = NormalizeNumber;

NormalizeNumber.prototype.init = function() {};

NormalizeNumber.prototype.draw = function(surface) {
    var tabs = xulHelper.tabBox(surface,
                                [ "No configuration", "Configuration" ],
                                { flex: 1 });

    var vbox0 = xmlHelper.appendNode(tabs[0], "vbox", null,
                       { flex: 1, pack: "center", align: "center" });
    xmlHelper.appendNode(vbox0, "caption", "It Just Works");

    var vbox1 = xmlHelper.appendNode(tabs[1], "vbox", null,
                       { flex: 1, pack: "top", align: "center" });
    xulHelper.jsonPathMapField(vbox1, this, "in", "out",
      {path:"$.output", key:"hits"},
      {path:"$.output", key:"hits"});
};

NormalizeNumber.prototype.normalize = function (number) {
  if (typeof(number) === "undefined") {
//     logger.debug("no match, returning 0");
    return 0;
  }
  let val0 = number;
//   logger.debug("Normalizing number '" + val0 + "'");
  let val2 = val0.replace(/[.,]/g, "");
//   logger.debug("removed punctuation from '" + val0 + "' yielding '" + val2 + "'");
  if (!val2.match(/[0-9]/)) {
    throw new StepError("no numeric part in string '" + number + "'");
  } else {
    val3 = val2.replace(/^[^0-9]*([0-9]+).*$/, "$1");
//     logger.debug("extracted number from '" + val2 + "' yielding '" + val3 + "'");
  }
  return val3;
};

NormalizeNumber.prototype.run = function (task) {
  jsonPathHelper.mapElements(this.conf.in || {path:"$.output", key:"hits"},
                     this.conf.out,
                     NormalizeNumber.prototype.normalize, task.data);
};

NormalizeNumber.prototype.getClassName = function () {
  return "NormalizeNumber";
};

NormalizeNumber.prototype.getDisplayName = function () {
  return "Normalize number";
};

NormalizeNumber.prototype.getDescription = function () {
  return "Normalizes numbers (such as the hit-count) by eliminating commas and periods, and defaulting to 0 if there are no digits.";
};

NormalizeNumber.prototype.getVersion = function () {
  return "1.0";
};

NormalizeNumber.prototype.renderArgs = function () {
  let src = this.conf.in;
  let dst = this.conf.out;
  src = src ? src.key : "hits";
  dst = dst ? dst.key : src;
  return src + "->" + dst;
};

NormalizeNumber.prototype.upgrade = function (confVer, curVer, conf) {
  // can't upgrade if the connector is newer than the step
  if (confVer > curVer)
    return false;

  if (confVer < 0.2) {
    jsonPathHelper.upgradePostProc(this.conf);
  }

  return true;
};
