var EXPORTED_SYMBOLS = ["filterEditor"];

// Editor for the "HTTP filters" tab of the metadata editor

Components.utils.import("resource://indexdata/ui/app.js");
Components.utils.import("resource://indexdata/util/xmlHelper.js");
Components.utils.import("resource://indexdata/util/xulHelper.js");

var filterEditor = {
  doc: null,
  win: null,
  whitelist: null,
  blacklist: null,
  whitelistNode: null,
  blacklistNode: null,
  
  init: function (win) {
    this.win = win;
    this.doc = win.document;
    if (!this.getConnector().properties.whitelist) {
      this.getConnector().properties.whitelist = [];
    }
    if (!this.getConnector().properties.blacklist) {
      this.getConnector().properties.blacklist = [];
    }
    // make local copies of the lists, so we can click cancel
    var props = this.getConnector().properties;
    this.whitelist = this.copyArray(props.whitelist);
    this.blacklist = this.copyArray(props.blacklist);
    //this.blacklist = this.getConnector().properties.blacklist;
    this.whitelistNode = this.doc.getElementById("cfWhitelist");
    this.blacklistNode = this.doc.getElementById("cfBlacklist");
    this.renderList(this.blacklist, this.blacklistNode);
    this.renderList(this.whitelist, this.whitelistNode);
  },

  // little helper to make a local copy
  copyArray: function(array) {
    var arr = new Array( array.length);
    for ( var i in array ){
      arr[i] = array[i];
    }
    return arr;
  },
  
  getConnector: function () {
    return app.connector;
  },
  
  renderList: function (list, node) {
    xulHelper.clearList(node);
    var item;
    var box;
    for (var i=0; i<list.length; i++) {
      item = xmlHelper.appendNode(node, "listitem", null, 
        {"value":i, allowevents: true}, null, false);
      var cell = xmlHelper.appendNode(item, "listcell");
      box = xmlHelper.appendNode(cell, "textbox", null,
        { "flex":1, "value":list[i], 
          "class": "tight" });
      node.appendChild(item);
      box.addEventListener("input", function(e) {
        var pp = this.parentNode.parentNode;
        list[parseInt(pp.value, 10)] = this.value;
        app.set("canSave", true);
      }, false);
    }
    if (box) {
      box.focus();
      list.selectedItem = item;
    }
  },
  
  deleteSelected: function (list, node) {
    for (var i=0; i<node.selectedItems.length; i++) {
      list.splice(parseInt(node.selectedItems[i].value), 1);
    }
    app.set("canSave", true);
  },
  addBlack: function () {
    this.blacklist.push('');
    this.renderList(this.blacklist, this.blacklistNode);    
  },
  addWhite: function () {
    this.whitelist.push('');
    this.renderList(this.whitelist, this.whitelistNode);
  },
  delBlack: function () {
    this.deleteSelected(this.blacklist, this.blacklistNode);
    this.renderList(this.blacklist, this.blacklistNode);    
  },
  delWhite: function () {
    this.deleteSelected(this.whitelist, this.whitelistNode);
    this.renderList(this.whitelist, this.whitelistNode);
  },
  
  saveFilter: function() {
    var props = this.getConnector().properties;
    props.whitelist = this.whitelist;
    props.blacklist = this.blacklist;
    app.connector.updateContentFilter();
  },
  
};
