%define idmetaversion %(. ./IDMETA; printf $VERSION )
Summary: Connector Framework
Name: cf
Version: %{idmetaversion}
Release: 1indexdata
%define is_suse %(test -e /etc/SuSE-release && echo 1 || echo 0)
BuildRequires: gcc gcc-c++ pkgconfig libxslt-devel readline-devel
BuildRequires: libmetaproxy4-devel >= 1.3.60
BuildRequires: httpd-devel libxml2-devel
BuildRequires: cf-xulrunner10-devel
License: proprietary
Group: Applications/Internet
Vendor: Index Data ApS <info@indexdata.dk>
Source: cf-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Packager: Adam Dickmeiss <adam@indexdata.dk>
URL: http://www.indexdata.com/connector-framework

%description
Connector Framework for CentOS 5 / SuSE 11 / RHEL 5.

%package engine
Summary: CF Engine
Group: Applications/Internet
Requires: cf-xulrunner10
Requires: metaproxy, netpbm-progs, xorg-x11-apps
%if %is_suse
Requires: xorg-x11-server-extra
%else
Requires: xorg-x11-server-Xvfb
%endif
Obsoletes: cf-xvfb

%description engine
CF Engine core

%package zserver
Summary: CF Z39.50/SRU server
Group: Applications/Internet
Requires: cf-engine = %{version}

%description zserver
Includes the Z39.50/SRU cf-zserver daemon based on YAZ GFS.

%package doc
Summary: CF documentation in HTML
Group: Applications/Internet

%description doc
Documentation for the Connector Framework Engine

%package squid
Summary: Proxy CF via squid
Group: Applications/Internet
Requires: squid, cf-engine = %{version}

%description squid
Enables CF to use squid for proxying traffic to the outside world.

%package proxy
Summary: Content proxy
Group: Applications/Internet
Requires: httpd, libxml2, cf-engine = %{version}

%description proxy
A proxy that rewrites links for the CF.

# cfrepo
# Requires: perl-XML-LibXSLT

%prep
%setup

%post engine
if [ -d /usr/lib64/metaproxy4/modules ]; then
       	if [ ! -e /usr/lib64/metaproxy4/modules/metaproxy_filter_cf.so ]; then
		ln -s /usr/lib64/cf/metaproxy_filter_cf.so /usr/lib64/metaproxy4/modules
	fi
fi
if [ -d /etc/metaproxy/filters-available ]; then
	if [ ! -e /etc/metaproxy/filters-available/cf.xml ]; then
		ln -s /usr/share/cf/metaproxy/cf.xml /etc/metaproxy/filters-available
		ln -sf ../filters-available/cf.xml /etc/metaproxy/filters-enabled/cf.xml
	fi
fi
if [ -f /var/run/metaproxy.pid ]; then
	/sbin/service metaproxy restart
fi
%preun engine
if [ $1 = 0 ]; then
	rm -f /usr/lib64/metaproxy4/modules/metaproxy_filter_cf.so
	rm -f /etc/metaproxy/filters-available/cf.xml
	rm -f /etc/metaproxy/filters-enabled/cf.xml
	if [ -f /var/run/metaproxy.pid ]; then
		/sbin/service metaproxy restart
	fi
fi

%post zserver
if [ $1 = 1 ]; then
        /sbin/chkconfig --add cf-zserver
        /sbin/service cf-zserver start > /dev/null 2>&1
else
        /sbin/service cf-zserver restart > /dev/null 2>&1
fi
%preun zserver
if [ $1 = 0 ]; then
	/sbin/service cf-zserver stop > /dev/null 2>&1
	/sbin/chkconfig --del cf-zserver
fi

# ------ BUILD --------
%build
# CF programs
cd engine/src
make clean
PKG_CONFIG_PATH=/usr/cf-xulrunner/lib64/pkgconfig make \
	OPT_FLAGS="-g -O" \
	YAZ_CONFIG=/usr/bin/yaz-config \
	MP_CONFIG=/usr/bin/metaproxy-config

# CF documentation
cd ../../engine/doc
make
# mod_proxy modules -malc 1/12/2012
cd ../../cfproxy/mod_proxy_html
%{_sbindir}/apxs -c -I . -I %{_includedir}/libxml2 -lxml2 mod_proxy_html.c
# xml2enc not used with mod_proxy_html 3.0.1
# Do not upgrade to 3.1.2 without checking that things really work!
#
cd ../..

# ------ INSTALL --------
%install
rm -fr ${RPM_BUILD_ROOT}

# install engine
cd engine/src
make prefix=${RPM_BUILD_ROOT}/usr libdir=${RPM_BUILD_ROOT}/%{_libdir} install
cp squid.js ${RPM_BUILD_ROOT}/usr/share/cf/app/defaults/preferences/user.js
mkdir -p ${RPM_BUILD_ROOT}/etc/init.d
mkdir -p ${RPM_BUILD_ROOT}/etc/sysconfig
mkdir -p  ${RPM_BUILD_ROOT}/etc/logrotate.d
mkdir -p  ${RPM_BUILD_ROOT}/etc/cron.daily
cd ..
cp -r etc ${RPM_BUILD_ROOT}/
cd doc
make prefix=${RPM_BUILD_ROOT}/usr libdir=${RPM_BUILD_ROOT}/%{_libdir} install
cd ../../cfproxy/mod_proxy_html
mkdir -p ${RPM_BUILD_ROOT}/%{_libdir}/httpd/modules
mkdir -p ${RPM_BUILD_ROOT}/etc/httpd/conf.d
%{_sbindir}/apxs -i -S LIBEXECDIR=${RPM_BUILD_ROOT}/%{_libdir}/httpd/modules -n mod_proxy_html mod_proxy_html.la
cd ../../rpm
patch ${RPM_BUILD_ROOT}/usr/share/cf/metaproxy/cf.xml cf.xml.patch
install -m755 cf-zserver.rpm.init ${RPM_BUILD_ROOT}/etc/init.d/cf-zserver
install -m755 cf-clean_sessions.cron ${RPM_BUILD_ROOT}/etc/cron.daily/cf-clean_sessions
cp cf-zserver.sysconfig ${RPM_BUILD_ROOT}/etc/sysconfig/cf-zserver
cp cf-zserver.rpm.logrotate ${RPM_BUILD_ROOT}/etc/logrotate.d/cf-zserver
cd ..
mkdir -p ${RPM_BUILD_ROOT}/etc/cf-proxy
mkdir -p ${RPM_BUILD_ROOT}/usr/share/cf-proxy
cp cfproxy/README ${RPM_BUILD_ROOT}/usr/share/cf-proxy
cp cfproxy/proxy.pl ${RPM_BUILD_ROOT}/usr/share/cf-proxy
cp cfproxy/apache-config ${RPM_BUILD_ROOT}/etc/cf-proxy
cp cfproxy/cproxy.cfg ${RPM_BUILD_ROOT}/etc/cf-proxy
cp cfproxy/proxy_html.conf ${RPM_BUILD_ROOT}/etc/httpd/conf.d/proxy_html.conf

%clean
rm -fr ${RPM_BUILD_ROOT}

%files engine
%defattr(-,root,root)
/usr/bin/cfrun
/usr/share/cf/modules
/usr/share/cf/app/components
/usr/share/cf/app/defaults/preferences/prefs.js
/usr/share/cf/app/chrome.manifest
/usr/share/man/man1/cfrun.*
/usr/share/man/man8/cf_webservice.*
/usr/share/cf/metaproxy
%{_libdir}/cf/*.so

%files zserver
%defattr(-,root,root)
%config(noreplace) /etc/sysconfig/cf-zserver
%config /etc/init.d/cf-zserver
%config(noreplace) /etc/cf-zserver/yazgfs.xml
/etc/cf-zserver/CF2MARC21slim.xsl
/usr/bin/cf-zserver
/usr/share/man/man8/cf-zserver.*
/etc/cron.daily/cf-clean_sessions
%config(noreplace) /etc/logrotate.d/cf-zserver

%files doc
%defattr(-,root,root)
/usr/share/doc/cf

%files squid
%defattr(-,root,root)
/usr/share/cf/app/defaults/preferences/user.js

%files proxy
%defattr(-,root,root)
%{_libdir}/httpd/modules/mod_proxy_html.so
/usr/share/cf-proxy/README
/usr/share/cf-proxy/proxy.pl
%config(noreplace) /etc/cf-proxy/apache-config
%config(noreplace) /etc/cf-proxy/cproxy.cfg
%config(noreplace) /etc/httpd/conf.d/proxy_html.conf
