#!/bin/bash
# Simple script to show what tests we have for each module
# Checks
#   - Unit test function
#   - Test connector with the module name in its name
#   - Step used in any test connector
#
# Needs to be run in .../cf so that relative paths are all right

#MODULES="builder/modules/util/*.js builder/modules/steps/*/*.js"
MODULES="builder/modules/steps/*/*.js"

CONNECTORS="connectors/*.cf connectors/cf-zserver-regression/*.cf \
            connectors/mp-regression/*.cf connectors/ws-regression/*.cf"

for M in $MODULES
do
  BN=`basename $M .js`
  if grep -q unitTest $M
  then
    HASUNITTEST="Unit test."
  else
    HASUNITTEST=""
  fi
  # Test connector with the step name in its name
  if ls $CONNECTORS | grep -qi $BN
  then 
    HASTESTCONNECTOR="Test connector."
  else
    HASTESTCONNECTOR=""
  fi
  # Test connectors using the step
  CONNCOUNT=`xmllint --format $CONNECTORS | grep -iw step.name=.$BN. | wc -l`
  if [ $CONNCOUNT == "0" ]
  then 
    USEDINTESTS=""
  else
    USEDINTESTS="Mentioned $CONNCOUNT times in test connectors."
  fi
  SUMMARY="$HASUNITTEST $HASTESTCONNECTOR $USEDINTESTS"
  if [ "$SUMMARY" == "  " ]
  then
    SUMMARY="NO TESTS AT ALL"
  fi
  echo $BN: $SUMMARY
done
