#!/bin/sh
# Copyright (c) 2011-2013 IndexData ApS. http://indexdata.com
#
# cf-branch-test - test a bunch of CF branches in a row

RET=0
logdir=$(mktemp -d /tmp/cf-branch-test.XXXXXX)

check() {
   branch=$1
   number=$2
   max=1	# N tests

   logfile=$logdir/log.$branch
   for i in `perl -e "print qq{x\n} x $max"`
   do
     echo "Start test.... $branch $number $i"
     CF_REGRESSION_NUMBER=$number make_opt="-sj4" cf_branch=$branch cf-bootstrap-light.sh 
     if [ $? -ne 0 ]; then
	RET=$(expr $RET + 1)
     fi
   done > $logfile 2>&1
   echo "RET: $RET" >> $logfile
}

check master 
check b2.22
check b2.21
check b2.20
check b2.19
check wosch 

echo "Status: $RET"
ls -l $logdir/log.*

