var EXPORTED_SYMBOLS = ["Break"];
Components.utils.import('resource://indexdata/runtime/Step.js');
var Break = function () { this.conf = {}; };
Break.prototype = new Step();
Break.prototype.constructor = Break;
Break.prototype.init = function() {};
Break.prototype.draw = function(surface) {};
Break.prototype.run = function (task) {
  task.interrupt(30000);
  // can't break at the top level
  if (task.block.nextBlock) { 
    task.info("BREAK.\n", this);
    var leaf = task.block.nextBlock;
    while (leaf.nextBlock) { leaf = leaf.nextBlock };
    var toBreak = leaf;
    // keep cancelling blocks until we break when we break something breakable
    while (toBreak.previousBlock) {
      toBreak.cancel();
      task.debug("Cancelled block named: " + toBreak.name, this);
      if (toBreak.parentStep.isBreakable) break;
      toBreak = toBreak.previousBlock;
    }
    leaf.resume();
  } else task.resume();
};
Break.prototype.getClassName = function () { return "Break"; };
Break.prototype.getDisplayName = function () { return "Break"; };
Break.prototype.getDescription = function () { return ""; };
Break.prototype.getVersion = function () { return "1.0"; };
Break.prototype.getUsedArgs = function () { return []; };
Break.prototype.renderArgs = function () { return "" };
