var EXPORTED_SYMBOLS = ["Delay"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');

var Delay = function () {
  this.conf = {};
  this.conf['delay'] = 20;
};
Delay.prototype = new Step();
Delay.prototype.constructor = Delay;

Delay.prototype.init = function() {};
Delay.prototype.draw = function(surface) {
  xulHelper.inputField(surface, this, 'delay', "Delay (ms): ", '100', {'width':'40'});
};
Delay.prototype.run = function (task) {
  if (parseInt(this.conf['delay']) < 1) {
    throw new StepError("delay not specified in the configuration");
  }
  task.interrupt(parseInt(this.conf['delay']));
};

Delay.prototype.getClassName = function () {
  return "Delay";
};

Delay.prototype.getDisplayName = function () {
  return "Delay";
};

Delay.prototype.getDescription = function () {
  return "Wait a given number of milliseconds before executing the next step.";
};

Delay.prototype.getVersion = function () {
  return "0.1";
};

Delay.prototype.renderArgs = function () {
  return this.conf.delay + "ms";
};
