var EXPORTED_SYMBOLS = ["RegexEditor"];
Components.utils.import('resource://indexdata/util/htmlHelper.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import("resource://indexdata/util/mozHelper.js");

var RegexEditor = function (regex, text, flags, cb) {
  var context = this;
  this.doc = null;
  this.win = null;
  this.callingRegex = regex;
  this.callingText = text;
  this.callingFlags = flags;
  this.cb = cb;

  this.chromewin = mozHelper.openOrFocusWindow(
    function (e) {
      context.doc = e.target;
      context.win = context.doc.getElementsByTagName("window").item(0);
      context.init();
    },
    "chrome://cfbuilder/content/regex_editor.xul",
    "cfRegexEditorWindow",
    "resizable=yes,status=yes,dependent=yes,chrome=yes,centerscreen"
  );
};

RegexEditor.prototype.init = function() {
  var context = this;
  var ui = {};

  ui.regex = this.doc.getElementById("cfRegex");
  ui.text = this.doc.getElementById("cfRegexText");
  ui.preview = this.doc.getElementById("cfRegexPreview");
  ui.groups = this.doc.getElementById("cfRegexGroups");
  ui.gFlag = this.doc.getElementById("cfRegexFlagG");
  ui.iFlag = this.doc.getElementById("cfRegexFlagI");
  ui.mFlag = this.doc.getElementById("cfRegexFlagM");

  ui.regex.value = this.callingRegex;
  ui.text.value = this.callingText;
  ui.gFlag.checked = this.callingFlags.indexOf('g') !== -1;
  ui.iFlag.checked = this.callingFlags.indexOf('i') !== -1;
  ui.mFlag.checked = this.callingFlags.indexOf('m') !== -1;

  var pollFlags = function() {
    var flags = "";
    if (ui.gFlag.checked) flags += 'g';
    if (ui.iFlag.checked) flags += 'i';
    if (ui.mFlag.checked) flags += 'm';
    return flags;
  }

  var highlightMatches = function() {
    xmlHelper.emptyChildren(ui.groups, "html:ol");
    if (ui.regex.value) {
      try {
        var regex = new RegExp (ui.regex.value, pollFlags());
      }
      catch (e) {
        ui.preview.innerHTML = '<html:em>Invalid regex.</html:em>';
        return;
      }

      // Run regex against unescaped value, add placeholders for highlight HTML
      // so we can escape all HTML before adding the highlight for final display.
      let tagged = htmlHelper.escapeHTML(ui.text.value.replace(regex,
        function(match) {
          return '[:STARTHIGHLIGHT:]' + match + '[:STOPHIGHLIGHT:]';
      }));
      tagged = tagged.replace(/\[\:STARTHIGHLIGHT\:\]/g,
        '<html:span style="color: black; background-color: yellow;">');
      tagged = tagged.replace(/\[\:STOPHIGHLIGHT\:\]/g,
        '</html:span>');
      ui.preview.innerHTML = tagged;

      // well, actually, highlightMatchesAndDisplayGroups
      var groups;
      while ((groups = regex.exec(ui.text.value)) &&
        typeof(groups) === "object" &&
        typeof(groups[1]) !== "undefined") {
        var list = xmlHelper.appendNode(ui.groups, "html:ol", null, null, "http://www.w3.org/1999/xhtml");
        for (var i=1; i < groups.length; i++) {
          xmlHelper.appendNode(list, "html:li", groups[i], null, "http://www.w3.org/1999/xhtml");
        }
        if (!ui.gFlag.checked) break;
      }
    }
  };

  ui.regex.addEventListener("input", highlightMatches, false);
  ui.text.addEventListener("input", highlightMatches, false);
  ui.regex.addEventListener("change", highlightMatches, false);
  ui.text.addEventListener("change", highlightMatches, false);
  ui.gFlag.addEventListener("command", highlightMatches, false);
  ui.iFlag.addEventListener("command", highlightMatches, false);
  ui.mFlag.addEventListener("command", highlightMatches, false);
  this.doc.getElementById("cfRegexUse").addEventListener("command",
    function() {
      context.cb(ui.regex.value, pollFlags());
      context.chromewin.close();
    }, false);
  this.doc.getElementById("cfRegexCancel").addEventListener("command",
    function() {
      context.chromewin.close();
    }, false);

  highlightMatches();

}
