var EXPORTED_SYMBOLS = ["metaEditor"];

// Editor for the connector metadata

Components.utils.import("resource://indexdata/ui/app.js");
Components.utils.import("resource://indexdata/util/xmlHelper.js");
Components.utils.import("resource://indexdata/util/logging.js");

var logger = logging.getLogger();

var metaEditor = {
  doc: null,
  win: null,
  inputs: [],

  init: function (win) {
    this.win = win;
    this.doc = win.document;
    this.inputs = [];
    this.refreshMeta();
    this.flagsinput = null;
    return this;
  },

  getConnector: function () {
    return app.connector;
  },

  // Helper to refresh the capability flag, when the user changes something
  // on those tabs
  refreshFlags: function ( flagstr ) {
    var fi = this.doc.getElementById("cf_flags" );
    if ( ! fi ) {
      logger.debug("MetaEditor: No 'cf_flags' input to update! " + fi +
          "  ninps=" + this.inputs.length );
      return; // should never happen
    }
    fi.value = flagstr;
  },
  
  refreshMeta: function () {
    var rows = this.doc.getElementById("cfMetaRows");
    xmlHelper.emptyChildren(rows);
    this.inputs = [];
    this.flagsinput = null;
      // for the case this gets called from the capability flag editor
    var metaData = this.getConnector().metaData;
    // we ask the template what to draw
    var metaItems = this.getConnector().getTemplate().getMetaData();
    for (var i=0; i<metaItems.length; i++) {
      var name = metaItems[i].name;
      var txtBoxId = "cf_" + name;
      i
      var dispName = metaItems[i].displayName;
      if (!dispName)
        dispName = name.charAt(0).toUpperCase() 
        + name.substr(1).toLowerCase();
      var toolTip = metaItems[i].note;
      var row = xmlHelper.appendNode(rows, "row", null, { align: "center" });
      xmlHelper.appendNode(row, "label", null, {value: dispName, width: 120,
        control: txtBoxId, crop: "end", tooltiptext: dispName+"\n\n"+toolTip});
      var attrs = { value: metaData[name], userdata: name, 
        flex: 1, size: 50, id: txtBoxId}
      if (metaItems[i].long != undefined &&
          metaItems[i].long == "yes") {
        attrs.multiline = "true";
        attrs.rows = 3;
      }
      if (metaItems[i].editable != undefined &&
          metaItems[i].editable == "false") {
        attrs.readonly = "true";
      }
      var txtBox = xmlHelper.appendNode(row, "textbox", null, attrs);
      this.inputs.push(txtBox);
      var win = this.win;
      if (metaItems[i].warn) {
        txtBox.setAttribute("warnmsg", metaItems[i].warn);
        txtBox.setAttribute("warnshown", "no");
        txtBox.addEventListener("focus", function (e) {
          var show = this.getAttribute("warnshown") === "no";
          if (show) {
            var ret = win.confirm(this.getAttribute("warnmsg"));
            if (ret) this.setAttribute("warnshown", "yes");
          }

          //tried dispatching custom event but after that the input is
          //higlighted but has no cursor
          /*if (e.detail === 999) {
          } else {
            logger.debug("Im not 999");
            e.stopPropagation();
            e.preventDefault();
            win.alert(this.getAttribute("warnmsg"));
            var myevt = win.document.createEvent("UIEvents");
            myevt.initUIEvent("focus", true, true, win, 999);
            this.dispatchEvent(myevt);
          }
          */
        }, false);
      }
    }
  },

  // Called when the user clicks OK. Nothing gets saved until then, so the
  // user can click cancel instead.
  saveMeta: function() {
    for ( var i in this.inputs ) {
      var n = this.inputs[i].getAttribute("userdata");
      var v = this.inputs[i].value;
      this.getConnector().metaData[n]=v;
      dump("Save input: " + i + ": " + n + "='" + v + "'\n");
    }
    app.canSave = true;
    app.notify("canSave");
  }
  
};
