var EXPORTED_SYMBOLS = ["IfElse"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/runtime/Block.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/runtime/Conditional.js');
var IfElse = function () {
 this.conf = {};
 this.selectedTab = 0;
};
IfElse.prototype = new Step();
IfElse.prototype.constructor = IfElse;
IfElse.prototype.setDefaults = function () {
  // array of arrays for conditions for each conditional
  this.conf.conditionses = [[],[{operator:'always', operands:[]}]];
  let len = this.conf.conditionses.length;
  for (let i = 0; i < len; i++) {
    let label = i < 1 ? "if" : i < len-1 ? "else if" : "else";
    this.blocks.push(new Block(null, 'if'+i, label, this));
  }
};
IfElse.prototype.init = function(task) {
  this.conditionals = [];
  let len = this.conf.conditionses.length;
  for (let i = 0; i < len; i++) {
    this.conditionals.push(new Conditional(this.conf.conditionses[i],
                                           this.task.data));
  }
};
IfElse.prototype.draw = function(surface) {
  var context = this;
  var box = xmlHelper.appendNode(surface, "tabbox", null, { flex: 1 });
  var tabs = xmlHelper.appendNode(box, "tabs");
  var panels = xmlHelper.appendNode(box, "tabpanels", null, { flex: 1 });
  var conditionals = this.conditionals;
  for (let i = 0; i < conditionals.length - 1; i++) {
    let conditional = conditionals[i];
    let tabattrs = {};
    tabattrs.label = conditional.toString();
    tabattrs.crop = 'end';
    tabattrs.style = "max-width: 15em;";
    if (tabattrs.label === "") tabattrs.label = 'New';
    let tab = xmlHelper.appendNode(tabs, 'tab', null, tabattrs);
    let panel = xmlHelper.appendNode(panels, "tabpanel", null, { flex: 1 }); 
    xmlHelper.appendNode(panel, "caption", "If: ");
    var condBox = xmlHelper.appendNode(panel, "vbox");
    conditional.draw(condBox, this);
  }
  tabs.selectedIndex = this.selectedTab;
  var refresh = function (sel) {
    let len = context.blocks.length;
    for (let i = 0; i < len; i++) {
      context.blocks[i].label = i < 1 ? "if" : i < len-1 ? "else if" : "else";
      context.blocks[i].name = 'if'+i;
    }
    context.selectedTab = sel;
    context.init();
    Components.utils.import("resource://indexdata/ui/taskPane.js");
    taskPane.stepTree.refresh();
    xmlHelper.emptyChildren(surface);
    context.draw(surface);
  }
  var add = xmlHelper.appendNode(tabs, 'button', null, {
      image: 'chrome://cfbuilder/content/icons/tab-new.png',
      tooltiptext: 'Add another conditional block',
      style: 'min-width: 10px; margin: 0; padding: 0;' }); 
  add.addEventListener("click", function (e) {
    // -1 to get the last index, -1 to skip the else, +1 to add after the last entry
    let last = context.conf.conditionses.length - 1;
    context.conf.conditionses.splice(last, 0, []); 
    context.blocks.splice(last, 0, new Block(context.task, 'if'+last, 'else if', context)); 
    refresh();
  }, false);
  var left = xmlHelper.appendNode(tabs, 'button', null, {
      image: 'chrome://cfbuilder/content/icons/go-previous.png',
      tooltiptext: 'Move this conditional before previous',
      style: 'min-width: 10px; margin: 0;' }); 
  left.addEventListener("click", function (e) {
    let sel = tabs.selectedIndex;
    if ( typeof(sel) !== 'number' || sel === 0) return;
    let removed = context.conf.conditionses.splice(sel, 1)[0]; 
    context.conf.conditionses.splice(sel-1, 0, removed); 
    let removed = context.blocks.splice(sel, 1)[0]; 
    context.blocks.splice(sel-1, 0, removed); 
    refresh(sel - 1);
  }, false);
  var right = xmlHelper.appendNode(tabs, 'button', null, {
      image: 'chrome://cfbuilder/content/icons/go-next.png',
      tooltiptext: 'Move this conditional after next',
      style: 'min-width: 10px; margin: 0;' }); 
  right.addEventListener("click", function (e) {
    let sel = tabs.selectedIndex;
    if ( typeof(sel) !== 'number' || sel === context.conf.conditionses.length - 2) return;
    let removed = context.conf.conditionses.splice(sel, 1)[0]; 
    context.conf.conditionses.splice(sel+1, 0, removed); 
    let removed = context.blocks.splice(sel, 1)[0]; 
    context.blocks.splice(sel+1, 0, removed); 
    refresh(sel + 1);
  }, false);
  var remove = xmlHelper.appendNode(tabs, 'button', null, {
      image: 'chrome://cfbuilder/content/icons/process-stop.png',
      style: 'min-width: 10px; margin: 0;' }); 
  remove.addEventListener("click", function (e) {
    let sel = tabs.selectedIndex;
    if ( typeof(sel) !== 'number' || context.conf.conditionses.length < 2) return;
    context.conf.conditionses.splice(sel, 1)[0]; 
    context.blocks.splice(sel, 1)[0]; 
    refresh(sel > 1 ? sel-1 : 0);
  }, false);
};
IfElse.prototype.run = function (task, block) {
  for (let i = 0; i < this.conditionals.length; i++) {
    if (this.conditionals[i].eval()) {
      this.blocks[i].run(block);
      break;
    }
  }
};
IfElse.prototype.getClassName = function () { return "IfElse"; };
IfElse.prototype.getDisplayName = function () { return "Conditional"; };
IfElse.prototype.getDescription = function () { return "If... Else If... Else"; };
IfElse.prototype.getVersion = function () { return "1.1"; };
IfElse.prototype.getUsedArgs = function () { return []; }
IfElse.prototype.renderBlockArgs = function (i) {
  if (i == this.conditionals.length-1) return "";
  return String(this.conditionals[i]);
};
IfElse.prototype.renderArgs = function () {
  if (Array.isArray(this.conditionals)) return "(" +this.conditionals.length + " cases)";
};
