var EXPORTED_SYMBOLS = ["stepBrowser"];
Components.utils.import("resource://indexdata/ui/app.js");
Components.utils.import("resource://indexdata/util/logging.js");
Components.utils.import("resource://indexdata/util/xmlHelper.js");
Components.utils.import("resource://indexdata/util/xulHelper.js");
Components.utils.import("resource://indexdata/util/textHelper.js");
Components.utils.import('resource://indexdata/ui/taskPane.js');

// Dirty hack to get a step to report errors better. Import it here,
// and the step browser fails. Often we get proper error messages
// anyway, but some types of errors just result in 'file not found'
// and the step missing from the step browser.
//Components.utils.import("resource://indexdata/steps/fullquerylimit/fullquerylimit.js");

var stepBrowser = {
  doc: null,
  win: null,
  list: null,
  steps: [],
  stepHash: {},

  init: function (win) {
    this.win = win;
    this.doc = win.document;
    this.list = this.doc.getElementById("cfNewStepList");
    this.steps = [];
    this.stepHash = {};

    this.doc.getElementById("cfNewStepShowAllCheck").setAttribute("checked", app.listAllSteps);
    this.doc.getElementById("cfNewStepStickyCheck").setAttribute("checked", app.stickyNewStep);

    var context = this;
    app.openResAndDo(["modules","steps"], function (stepDir) {
      stepDirs = stepDir.directoryEntries;
      if (stepDirs == null) {
        logging.getLogger().debug("Cannot find step directory");
        return;
      }

      // load all valid steps
      while (stepDirs.hasMoreElements()) {
        var stepDir = stepDirs.getNext()
          .QueryInterface(Components.interfaces.nsIFile);
        var stepDirName = stepDir.leafName;
        // try to instantiate
        var step = null;
        try {
          Components.utils.import('resource://indexdata/steps/'
            + stepDirName + '/' + stepDirName + '.js');
          step = eval("new " + textHelper.usToCC(stepDirName) + "()");
        } catch (e) {
          logging.getLogger().
            debug("Cannot instantiate '"+ stepDirName +"' : " + e.message );
          if ( e.lineNumber && e.fileName )
            logging.getLogger().
              debug( e.fileName + ":" + e.lineNumber );
          continue;
        }
        if (!step.isDeprecated()) {
          step.dirName = stepDirName;
          step.boxText = step.getDescription() || "";
          step.boxText += "\n\nVersion: " + step.getVersion();
          context.stepHash[step.dirName] = step;
          context.steps.push(step);
        }
      }

      // sort by name
      context.steps.sort(function(A,B) {
        var a = A.getDisplayName();
        var b = B.getDisplayName();
        return (a < b ? -1 : a > b ? 1 : 0);
      });

      context.refresh();
    });
    // doesn't seem to actually focus it :(
    this.list.focus();
  },
  addStepToList: function (step) {
    var item = xmlHelper.appendNode(this.list, "listitem", null,
      {"value": step.dirName });
    xmlHelper.appendNode(item, "label", null,
      {"value" : step.getDisplayName()});
    this.list.appendChild(item);
  },
  showAll: function () {
    xulHelper.clearList(this.list);

    // generate UI
    for (var i = 0; i < this.steps.length; i++) {
      this.addStepToList(this.steps[i]);
    }
  },
  showCommon: function () {
    xulHelper.clearList(this.list);
    var cso = app.selectedTask.getTemplate().properties.commonStepOrder;
    var maybeStep;
    for (var i = 0; i < cso.length; i++) {
      maybeStep = this.stepHash[cso[i]];
      if (maybeStep)
        this.addStepToList(maybeStep);
    }
  },
  refresh: function () {
    if (app.listAllSteps || !app.selectedTask.getTemplate().properties.commonStepOrder)
      this.showAll();
    else
      this.showCommon();
  },
  getBoxText: function (dirName) {
    return this.stepHash[dirName].boxText;
  },
  toggleListAllPersist: function () {
    app.listAllSteps = !app.listAllSteps;
    this.showAll();
  },
  toggleSticky: function () {
    app.stickyNewStep = !app.stickyNewStep;
    let prefs = Components.classes["@mozilla.org/preferences-service;1"]
      .getService(Components.interfaces.nsIPrefService)
      .getBranch("indexdata.cf.");
    prefs.setBoolPref("stickyNewStep", app.stickyNewStep);
  },
  createStep: function (stepName) {
    (function () { taskPane.stepTree.newStep(stepName) })();
    if (!app.stickyNewStep) stepBrowser.win.close();
    // this doesn't focus it. neither does stepBox.firstElementChild.focus()
    taskPane.stepBox.focus();
  }
};
