var EXPORTED_SYMBOLS = ["justObserve"];
Components.utils.import('resource://indexdata/util/loadDetectors/progressListen.js');
const STATE_START = Components.interfaces.nsIWebProgressListener.STATE_START;
const STATE_STOP = Components.interfaces.nsIWebProgressListener.STATE_STOP;
const STATE_REDIRECTING = Components.interfaces.nsIWebProgressListener.STATE_REDIRECTING;
const STATE_IS_DOCUMENT = Components.interfaces.nsIWebProgressListener.STATE_IS_DOCUMENT;
const NOTIFY_ALL = Components.interfaces.nsIWebProgress.NOTIFY_ALL;
const OBSRV = Components.classes["@mozilla.org/observer-service;1"]
  .getService(Components.interfaces.nsIObserverService);

var justObserve = {
  started: [],
  task: null,
  quietTime: 20,
  quietTimer: Components.classes["@mozilla.org/timer;1"] 
    .createInstance(Components.interfaces.nsITimer),  
  defaultConf: {
    quietTime: 20,
  },

  getDisplayName: function() {
    return "nsIObserverService only";
  },

  draw : function(surface, conf) {
    Components.utils.import('resource://indexdata/util/xmlHelper.js');
    xmlHelper.appendNode(surface, "label", null,
      { control: "quietTime", value:"New load threshold (ms):" });
    var quietTime = xmlHelper.appendNode(surface, "textbox", null,
      { id:"quietTime", value:conf.quietTime||this.defaultConf.quietTime});
    quietTime.addEventListener("input", function(e) {
      conf.quietTime = parseInt(quietTime.value);
    }, false);       
  },
  
  wait: function(task, conf, step) {
    this.task = task;
    this.step = step;
    this.started = [];
   
    // conf checking and defaults
    if (conf.quietTime)
      this.quietTime = conf.quietTime;
    else
      this.quietTime = this.defaultConf.quietTime;
    
    OBSRV.addObserver(this, "http-on-modify-request", false);
    OBSRV.addObserver(this, "http-on-examine-response", false);
    OBSRV.addObserver(this, "http-on-examine-cached-response", false);
  },
  
  detatch: function () {
      OBSRV.removeObserver(this, "http-on-modify-request");
      OBSRV.removeObserver(this, "http-on-examine-response");
      OBSRV.removeObserver(this, "http-on-examine-cached-response");  
  },
  
  onTimeout: progressListen.onTimeout,
  
  QueryInterface: function(aIID) {
    if (aIID.equals(Components.interfaces.nsIObserver) ||
        aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
        aIID.equals(Components.interfaces.nsISupports))
      return this;
    throw Components.results.NS_NOINTERFACE;
  },

  removeRequest: progressListen.removeRequest,
  requestStart: progressListen.requestStart,
  requestStop: progressListen.requestStop,

  observe: function(subject, topic, data) {
    subject.QueryInterface(Components.interfaces.nsIRequest);
    subject.QueryInterface(Components.interfaces.nsIHttpChannel);    
    if (topic=="http-on-modify-request")
      this.requestStart(subject);
    if (topic=="http-on-examine-response" || topic=="http-on-examine-cached-response")
      this.requestStop(subject);
  },
};
