#!/bin/sh
C=/usr/share/cf/connectors/inactive/doaj.cf
if test "$1"; then
	C=$1
fi
H=http://localhost:9070/connector
# Create session (empty content)
curl --output ws.log --data-binary "" $H
# Parse it
ID=`cat ws.log | cut -d":" -f 2|cut -d"}" -f 1`

# Load connector file
curl --data-binary @$C $H/$ID/load_cf

# Run a set of tests
curl --header "Content-Type: application/json; charset=UTF-8" --data-binary "{}" \
	$H/$ID/run_tests/search,parse,next,parse
# Run task search
curl --header "Content-Type: application/json" \
	--data-binary "{\"keyword\":\"water\"}" \
	$H/$ID/run_task/search
# Run task parse
curl --header "Content-Type: application/json" --data-binary "{}" \
	$H/$ID/run_task/parse
# Take screen shot (requires pnmtopng, xwdtopnm)
if test -x /usr/bin/pnmtopng; then
	curl --output screen.png \
    	--data-binary "{}" 	$H/$ID/screen_shot
fi
# Run opt task init
curl --output init.log --header "Content-Type: application/json" --data-binary "{}" \
	$H/$ID/run_task_opt/init
# Get log
curl --header "Content-Type: application/json" --data-binary "{}" \
	$H/$ID/log
# Get dom
curl --header "Content-Type: text/html" --data-binary "{}" \
	$H/$ID/dom_string
# Delete the connector
curl --request DELETE $H/$ID

