#!/usr/bin/perl
#
# Copyright (c) 2009 Index Data
# Author: Wolfram Schneider, Index Data
#
#  validate-connectors.pl - check the connector for valid XML
#

use XML::LibXSLT;
use XML::LibXML;

use strict;
use warnings;

sub usage {

    return <<EOF;
usage $0 connector ...
EOF
}

sub load_connector {
    my ($fn) = shift;

    eval {
        my $xml_parser = XML::LibXML->new();
        my $conn       = $xml_parser->parse_file($fn);
        my $title =
          $conn->findvalue('/connector/metaData/meta[@name="title"]/@content');
    };

    die qq{XML parsing failed: $@} if $@;

}

die usage if scalar(@ARGV) <= 0;
map { &load_connector($_) } @ARGV;

