#!/bin/bash
DIR=`dirname "$0"`
STEP_DIR=$DIR/builder/modules/steps
STEPS=`ls $STEP_DIR`
TEST_DIR=$DIR/connectors
baddies=
for i in $STEPS; do
  if ! grep "name=\"$i\"" $TEST_DIR/*cf > /dev/null; then
    WHO=`git log --format="%an" "$STEP_DIR/$i" | awk '{count[$1]++}END{for(j in count) print count[j] " " j}' | sort -g | tail -1 | cut -d\  -f2`
    echo "WARN: '$i' is not covered by regression tests, bad $WHO!"
    baddies="$baddies$WHO
"
  fi
done
echo "Naughtiest programmers:"
echo "$baddies" | grep . | sort | uniq -c | sort -k1rn
echo "Bad, Bad" `echo "$baddies" | grep . | sort | uniq -c | sort -k1rn | sed 1q | sed 's/.*[0-9]\(.*\)/\1!/'`
