#!/bin/sh
#
# test-ws.sh - test a connector with the web service API
#
# usage: ./test-ws.sh "search string" connector.cf
#
# use DEBUG=1 to get a verbose output

PATH=/opt/local/bin:/usr/local/bin:/bin:/usr/bin; export PATH

keyword=${1-"water"}
connector=${2-"../../connectors/cftest-04-openlibrary.cf"}

: ${CFWS_URL="http://connect.indexdata.com:210/connector"}
: ${DEBUG=0}
: ${XML=true}

trap 'cleanup $?'  0 1 2 3 4 5 6 7 8 10 12 13 14 15

wslog=`mktemp -t wsapi.XXXXXXXXXX` || exit 2

# get rid off the curl progress bar and fail at error
curl="curl -Ssf"

case $DEBUG in
	1|2) set -x ;;
esac

cleanup () 
{
	error=$1
	if [ $error != 0 ]; then
		cat $wslog
		echo ""
		echo "curl died with exit status: $error"

		# force an expire of connector
		test -n "$id" && $curl --request DELETE $CFWS_URL/$id > /dev/null 2>&1 || true 
	fi
 	rm -f $wslog 
}

set -e

rootdir=`dirname $0`

if $XML; then 
	ACCEPT='text/xml'
else
	ACCEPT='*/*'
fi

# Post a connector and get an ID back
$curl --output $wslog --data-binary @"$connector" $CFWS_URL

# Parse it and extract the session ID
id=`perl -ne 'print "$1\n" if /:([^"}\n]+)/' $wslog`
if test -z "$id"; then
	echo "Alert: no CF WS id found"
	exit 2
fi
 
# Run a set of tests
#$curl --header "Content-Type: application/json"  --data-binary '{}' \
#    $CFWS_URL/$id/run_tests/search,parse,next,parse

# Run task search
$curl --output $wslog --header "Accept: $ACCEPT" --header "Content-Type: application/json"  --data-binary '{"keyword":"'$keyword'"}' \
    $CFWS_URL/$id/run_task/search
cat $wslog

# Run task parse
$curl --output $wslog --header "Accept: $ACCEPT" --header "Content-Type: application/json"  --data-binary '{}' \
    $CFWS_URL/$id/run_task/parse 
cat $wslog

# Delete the connector
$curl --request DELETE $CFWS_URL/$id

