var EXPORTED_SYMBOLS = ["FormatDate"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');
var FormatDate = function () { this.conf = {}; };
FormatDate.prototype = new Step();
FormatDate.prototype.constructor = FormatDate;
FormatDate.prototype.init = function(task) { };
FormatDate.prototype.draw = function(surface) {
  xulHelper.jsonPathMapField(surface, this, "in", "out");
  xulHelper.inputField(surface, this, "format", "Format string:");
};
FormatDate.prototype.run = function (task, block) {
  jsonPathHelper.mapElements(this.conf.in, this.conf.out, function (value) {
    if (typeof value === 'string') {
      return Date.parse(value).toLocaleFormat(this.conf.format)
    }
    else return value;
  }, task.data);
};
FormatDate.prototype.getClassName = function () { return "FormatDate"; };
FormatDate.prototype.getDisplayName = function () { return "Format date"; };
FormatDate.prototype.getDescription = function () {
  return "Format an ISO 8061 Extended Format string";
};
FormatDate.prototype.getVersion = function () { return "1.0"; };
FormatDate.prototype.getUsedArgs = function () {
  if (this.conf.in.path === "$.input") return [this.conf.in.key];
};
FormatDate.prototype.renderArgs = function () {
  return this.conf.in ? this.conf.in.key + " -> " + this.conf.out.key : "";
};
