var EXPORTED_SYMBOLS = ["Join"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');

var Join = function () {
  this.conf = {
    "in": undefined,
    out: undefined,
    glue: undefined,
  };
};

Join.prototype = new Step();
Join.prototype.constructor = Join;

Join.prototype.init = function() {};

Join.prototype.draw = function(surface) {
  xulHelper.jsonPathMapField(surface, this, "in", "out");
  xulHelper.inputField(surface, this, "glue", "Glue string", 140, { flex:1 });
};

Join.prototype.run = function (task) {
  var context = this;
  jsonPathHelper.map(context.conf.in, context.conf.out, function (list) {
    // Join an array
    if (Array.isArray(list)) return [list.join(context.conf.glue)]

    // Empty source---will delete dest on replace, add nothing for appent/concat
    if (typeof(list) === 'undefined') return undefined;

    throw new StepError("Non-array input passed to Join");
  }, task.data);
};

Join.prototype.getClassName = function () {
  return "Join";
};

Join.prototype.getDisplayName = function () {
  return "Join result";
};

Join.prototype.getDescription = function () {
  return "Glues the values of a repeated field together, joined " +
         "by a specified glue string, into one single field.";
};

Join.prototype.getVersion = function () {
  return "1.0";
};

Join.prototype.renderArgs = function () {
  if (!this.conf.in) return "";
  let src = this.conf.in;
  let dst = this.conf.out;
  src = src ? src.key : "date";
  dst = dst ? dst.key : src;
  return this.conf.glue || "," + " (" + src + "->" + dst + ")";
};

Join.prototype.upgrade = function (confVer, curVer, conf) {
  // can't upgrade if the connector is newer than the step
  if (confVer > curVer)
    return false;

  if (confVer < 0.2) {
    jsonPathHelper.upgradePostProc(this.conf);
  }

  return true;
};
