var EXPORTED_SYMBOLS = ["ScriptSandbox"];

// ScriptSandbox_sandbox  - run a script in a sandbox
// This is intended to replace the script step, in time when
// we can afford to deprecate the old script step, and eventually
// remove it. This is not merely a new version of the script step,
// since there is no way to upgrade existing scripts automatically,
// so it can not be compatible.

Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/waitForLoad.js');
Components.utils.import('resource://indexdata/util/logging.js');

var logger = logging.getLogger();

var ScriptSandbox = function () {
  this.conf = {};
  this.conf['script'] = '// Start with a descriptive comment\n' +
    '// Access $.variables like this: \n' +
    '//   task.data.output.hits = [ "0" ]; \n' +
    '// (always string values, always inside an array) \n' +
    'throw new StepError("Not implemented yet");';
};
ScriptSandbox.prototype = new Step();
ScriptSandbox.prototype.constructor = ScriptSandbox;

ScriptSandbox.prototype.init = function(task) {};

ScriptSandbox.prototype.draw = function(surface) {
  var context = this;
  var scriptBox = xmlHelper.appendNode(surface, "textbox", null, {"value":this.conf["script"], "flex":"1", "multiline":"true"});
  scriptBox.addEventListener("input", function (e) {
    context.conf['script'] = scriptBox.value;
  }, false);  
  xmlHelper.appendNode(surface, "label", "JavaScript code.  Throw 'Error' on failure.");
};




ScriptSandbox.prototype.run = function (task) {
  var step = this;
  var sb = new Components.utils.Sandbox(task.connector.getPageUrl());
  // in the builder the win is wrapped in XPCNW so unwrap
  if (this.getPageDoc().toString().indexOf("XPCNativeWrapper") != -1)
    var unsafeDoc = this.getPageDoc().wrappedJSObject;
  else
    var unsafeDoc = this.getPageDoc();
  // in the engine the getPageWindow returns an IFRAME so retrieve from the doc
  // instead
  var unsafeWin = unsafeDoc.defaultView;
  // wrap them before passing to the sb
  var safeWin = new XPCNativeWrapper(unsafeWin);
  var safeDoc = safeWin.document;
  sb.__proto__ = safeWin;
  sb.window = safeWin;
  sb.document = safeDoc;
  //clone the data, otherwise we get security exception on cross-sb access
  sb.data = JSON.parse(JSON.stringify(task.data));
  sb.logger = new XPCNativeWrapper(logging.getLogger("execution"));

  // backward compatible with older engines // sb.task = null; 
  sb.task = {};
  sb.task.data = sb.data;
  sb.task.output = sb.task.output;
  sb.task.input = sb.task.input;
  sb.getPageDoc = function () { return sb.document };

  var result = Components.utils.evalInSandbox(this.conf.script, sb);

  task.rebuildData(JSON.parse(JSON.stringify(sb.data)));
};

ScriptSandbox.prototype.getClassName = function () {
  return "ScriptSandbox";
};

ScriptSandbox.prototype.getDisplayName = function () {
  return "Script (Sandboxed)";
};

ScriptSandbox.prototype.getDescription = function () {
  return "Executes arbitrary JavaScriptSandbox code.  A tool of last resort.";
};

ScriptSandbox.prototype.getVersion = function () {
  return "0.1";
};

ScriptSandbox.prototype.renderArgs = function () {
    var p = this.conf.script.indexOf("\n");
    if (p == -1 )
        p = 50;
  return this.conf.script.slice(0,p);
};
