var EXPORTED_SYMBOLS = ["Split"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');

var Split = function () {
  this.conf = {
    "in": undefined,
    out: undefined,
    regex: undefined,
  };
};
Split.prototype = new Step();
Split.prototype.constructor = Split;

Split.prototype.init = function() {};

Split.prototype.draw = function(surface) {
  xulHelper.jsonPathMapField(surface, this, "in", "out");
  xulHelper.inputField(surface, this, "regex", "Regular expression", 140, { flex:1 });
};

Split.prototype.run = function (task) {
  var context = this;

  jsonPathHelper.map(context.conf.in, context.conf.out, function (list) {
    if (typeof list === 'undefined') return undefined;

    // Pathetically, the standard split() function won't do here,
    // due to the retarded rule where matches for parenthesised
    // subexpressions are included in the output.  This means that
    // when matching /(, | and )/ against "Kernighan and Richie",
    // you get three result strings: "Kernighan", " and " and
    // "Richie".
    // At some point we'll have to roll our own.
    var mapped = [];
    for (var i=0; i<list.length; i++) {
      mapped = mapped.concat(Split.halfDecentSplit(context.conf.regex, list[i]));
    }
    return mapped;
  }, task.data);
};

Split.halfDecentSplit = function (s, val) {
  s = "(.*?)(" + s + ")(.*)";
  var regex = new RegExp(s);
  var res = [];
  var a;
  while (a = regex.exec(val)) {
    res.push(a[1]);
    val = a[3];
  }
  res.push(val);
  return res;
};

Split.prototype.getClassName = function () {
  return "Split";
};

Split.prototype.getDisplayName = function () {
  return "Split result";
};

Split.prototype.getDescription = function () {
  return "Splits a result field using a specified separator to yield a list.";
};

Split.prototype.getVersion = function () {
  return "1.0";
};

Split.prototype.renderArgs = function () {
  let src = this.conf.in;
  let dst = this.conf.out;
  if (src) {
    dst = dst ? dst.key : src;
    return this.conf.regex || "" + " (" + src + "->" + dst + ")";
  } else {
    return "";
  }
};

Split.prototype.upgrade = function (confVer, curVer, conf) {
  // can't upgrade if the connector is newer than the step
  if (confVer > curVer)
    return false;

  if (confVer < 0.2) {
    jsonPathHelper.upgradePostProc(this.conf);
  }

  return true;
};
