var EXPORTED_SYMBOLS = ["capEditor"];
Components.utils.import("resource://indexdata/util/xmlHelper.js");
Components.utils.import("resource://indexdata/util/xulHelper.js");
Components.utils.import("resource://indexdata/util/logging.js");
Components.utils.import("resource://indexdata/ui/app.js");
Components.utils.import("resource://indexdata/ui/metaEditor.js");

var logger = logging.getLogger();

var capEditor = {
    doc: null,
    win: null,
    inputs: [], // all the pull-down input fields to save
    tabs: [], // the different tabs we have created for them
    metaedit : null,
    
    init: function (win, metaeditor) {
        this.win = win;
        this.doc = win.document;
        this.metaedit = metaeditor;
        this.drawCaps();
    },
    
    getConnector: function () {
        return app.connector;
    },

    // Helper to create a tab in the metadata editor
    createTab: function(tab) {
      //logger.debug("Creating capability tab '" + tab + "'");
      var tablist = this.doc.getElementById("tabs");
      xmlHelper.appendNode(tablist, "tab", null, {label: tab} );
      var panels = this.doc.getElementById("tabpanels");
      var grid = xmlHelper.appendNode(panels, "grid", null, {flex:1} );
      var cols = xmlHelper.appendNode(grid,"columns", null);
      xmlHelper.appendNode(cols,"column", null, {flex:1} );  // name
      xmlHelper.appendNode(cols,"column", null, {flex:1} );  // note
      xmlHelper.appendNode(cols,"column", null, {flex:1} );  // Radio
      var rows = xmlHelper.appendNode(grid, "rows", null );
      return rows;
    },


    
    // Draw the form with all the capabilities.
    drawCaps: function() {
        //logger.debug("Drawing Cap tabs");
        var context = this;
        
        // callback to recalculate the flags in the metaEditor
        // every time the user changes anything
        var recalc = function(e) {
          //logger.debug("CapEdit: recalc: " + e );
          var flagstr = "";
          var inps = context.inputs;
          //logger.debug("Found " + inps.length + " inputs to consider ");
          for ( var i=0; i<inps.length; i++ ) {
            var xid = inps[i].id;
            var seli = inps[i].selectedIndex;
            if ( seli == 0 ||
                  (seli == 2 && inps[i].cf_def ) ) {
              flagstr += xid + " ";
            }
          }
          context.metaedit.refreshFlags( flagstr );
        }; // recalc
        
        this.inputs = [];
        this.tabs = [];
        var rows; // = this.doc.getElementById("cfCapRows");
        var connector = this.getConnector()
        var templFlags = connector.getTemplate().getCapabilityFlags();
        var connFlags = connector.getCapabilityFlags();
        var tab = "Capabilities";  // default name, just in case
        // TODO - Check if there are flags in the connector not mentioned in meta,
        // and add into the templFlags;
        for ( var i = 0; i<templFlags.length; i++) {
          if ( templFlags[i].tab )
            tab = templFlags[i].tab; // keep previous, if not set
          if ( ! this.tabs[tab] )
            this.tabs[tab] = this.createTab( tab );
          rows = this.tabs[tab];
          var name = templFlags[i].name;
          var note = templFlags[i].note;
          var alias = templFlags[i].alias;
          var templdefault = templFlags[i].default;
          if ( templdefault == true || templdefault == "true" )
            templdefault = true;
          else // make sure we have a boolean!
            templdefault = false;
          var stepdefault = connector
                        .getCapabilityFlagDefault(name,templdefault, alias);
          var defstr = "Default YES";
          if ( ! stepdefault )
            defstr = "Default no";
          //logger.debug("flag '" + name + " =" + connFlags[name] +
          //   " td=" + templdefault + " (" + typeof(templdefault) + ") " +
          //   " sd=" + stepdefault );

          // Mozilla is picky about the selected attribute.
          // this is one way it actually works. Just setting
          // "selected" to false, undefined, or null will look good,
          // but produce bad results when getting selections out of
          // the radio group - especially if the user has not clickec
          // on any button!
          var yattrs = {"id":"Y", "label":"Yes" };
          var nattrs = {"id":"N", "label":"No" };
          var dattrs = {"id":"D", "label":defstr }
          if ( connFlags[name] == undefined ||
                connFlags[name] == null )
            dattrs["selected"] = true;
          else if ( connFlags[name] )
            yattrs["selected"] = true;
          else
            nattrs["selected"] = true;
          var row = xmlHelper.appendNode(rows, "row", null,
              { align: "center", cf_flagname: name });
          //var tb = xmlHelper.appendNode(row, "hbox", null, null, null);
          xmlHelper.appendNode(row, "caption", null, { "label": name} );
          xmlHelper.appendNode(row, "label", note );
          //var rbox = xmlHelper.appendNode(row, "hbox");
          var rg = xmlHelper.appendNode(row, "radiogroup", null,
                { "id": name,  "orient": "horizontal" } );
          var yr = xmlHelper.appendNode(rg, "radio", null, yattrs );
          xmlHelper.appendNode(rg, "radio", null, nattrs );
          xmlHelper.appendNode(rg, "radio", null, dattrs );
          rg.cf_def = stepdefault; // remember the default
          this.inputs.push(rg);
          rg.addEventListener("command", recalc, false);
        } // i
        recalc();  // get the flags right on the meta editor too!
    }, // drawCaps

   
    
    // TODO - Thu: Update the flags in metaEditor.
    // Then recalculate them before save/upload
    // Remove debug output, and commit.
    
    // Save the capability flags from the screen inputs into connector
    saveCaps: function () {
        var inps = this.inputs;
        //logger.debug("Found " + inps.length + " inputs to consider ");
        var connector = this.getConnector()
        connector.clearAllCapabilityFlags();
        for ( var i=0; i<inps.length; i++ ) {
            var xid = inps[i].id;
            var seli = inps[i].selectedIndex;
            /* logger.debug("Inp " + i + ": " + inps[i].id + " = " +
                inps[i].selectedIndex + " = " +  inps[i].selectedItem.id +
                // " selections:" + inps[i].cf_yr.selected + "/" +
                //   inps[i].cf_nr.selected + "/" + inps[i].cf_dr.selected +
                "" ); */
            var name = inps[i].id;
            if ( inps[i].selectedIndex == 0 )
                connector.setCapabilityFlag(name,true);
            else if ( inps[i].selectedIndex == 1 )
                connector.setCapabilityFlag(name,false);
        } // inputs loop
        // TODO  metaEditor.refreshFlags(); // force the new flags to be displayed right
    }, // saveCaps

        
}; // capEditor
