var EXPORTED_SYMBOLS = ["scratch"];
Components.utils.import("resource://indexdata/ui/app.js");
Components.utils.import("resource://indexdata/ui/StepTree.js");
Components.utils.import("resource://indexdata/runtime/Task.js");
Components.utils.import("resource://indexdata/runtime/Connector.js");
Components.utils.import("resource://indexdata/util/logging.js");
Components.utils.import("resource://indexdata/util/xmlHelper.js");
Components.utils.import("resource://gre/modules/FileUtils.jsm");
var prompts = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
              .getService(Components.interfaces.nsIPromptService);
var logger = logging.getLogger();
var scratch = {
  connector: null,
  task: null,
  stepTree: null,
  win: null,
  doc: null,
  file: null,
  ro: false,
  init: function (win) {
    var context = this;
    this.win = win;
    this.doc = win.document;
    this.stepTree = new StepTree();
    this.stepTree.init(this.doc.getElementById("stepTree"), {onChange: scratch.save});
    // creates profile/cfbuilder and profile/cfbuilder/scratch if missing
    this.file = FileUtils.getFile("ProfD", ["cfbuilder", "scratch", "default.cf"]);
    this.connector = new Connector();
    if (this.file.exists()) {
      this.load(this.file);
    } else {
      this.task = this.connector.createTask("scratch");
      this.stepTree.setTask(this.task);
      this.save();
      this.reflectFile();
    }
  },
  load: function (file) {
    this.connector.loadConfFromFile(file.path);
    let tasks = this.connector.getTasks();
    if (tasks.length > 0) {
      this.task = tasks[0];
      this.stepTree.setTask(this.task);
    }
    else logger.warn("Scratch connector contains no tasks.");
    this.file = file;
    this.reflectFile();
  },
  open: function () {
    // start in profile/cfbuilder/scratch
    let localScratchDir = FileUtils.getDir("ProfD", ["cfbuilder", "scratch"]);
    app.openBrowseDialog(scratch.win, "Choose connector...", "load",
      function (filePicker) {
        if (filePicker.file) {
          scratch.ro = false;
          scratch.load(filePicker.file);
        }
      }, null, localScratchDir);
  },
  openLibrary: function () {
    // start in scratch under the builder's install dir
    app.openResAndDo(["scratch"], function (scratchLibraryDir) {
      app.openBrowseDialog(scratch.win, "Choose connector...", "load",
        function (filePicker) {
          if (filePicker.file) {
            scratch.ro = true;
            scratch.load(filePicker.file);
          }
        }, null, scratchLibraryDir);
    });
  },
  newFile: function () {
    // start in profile/cfbuilder/scratch
    let localScratchDir = FileUtils.getDir("ProfD", ["cfbuilder", "scratch"]);
    app.openBrowseDialog(scratch.win, "Filename for new scratch connector...", "save",
      function (filePicker) {
        scratch.file = filePicker.file;
        scratch.connector = new Connector();
        scratch.task = scratch.connector.createTask("scratch");
        scratch.stepTree.setTask(scratch.task);
        scratch.save();
        scratch.reflectFile();
      }, null, localScratchDir);
  },
  reflectFile: function () {
    // update window title with new filename
    this.win.document.title = "Scratch - " + this.file.leafName;
    // collect elements that need to be disabled for read only files
    let modifyingControlIds = [
      "cut-step",
      "paste-step",
      "delete-step",
      "add-task",
      "remove-task"
    ];
    let modifyingElements = [];
    for (let i = 0; i < modifyingControlIds.length; i++) {
      modifyingElements.push(this.win.document.getElementById(modifyingControlIds[i]));
    }
    // enable or disable accordingly
    if (scratch.ro) {
      modifyingElements.forEach(function (el) {
        el.setAttribute("disabled", "true");
      });
    } else {
      modifyingElements.forEach(function (el) {
        el.setAttribute("disabled", "false");
      });
    }
    scratch.refreshTaskMenu();
    scratch.stepTree.refresh();
    scratch.stepTree.tree.focus();
  },
  save: function () {
    if (!scratch.ro) scratch.connector.saveConfToFile(scratch.file.path);
  },
  // Task handling
  onTaskSelect: function (tidx) {
    scratch.task = scratch.connector.getTaskById(tidx);
    scratch.stepTree.setTask(scratch.task);
    scratch.refreshTaskMenu();
  },
  refreshTaskMenu: function () {
    var tasks = scratch.connector.getTasks();
    var menu = scratch.doc.getElementById("taskMenu");
    var popup = menu.getElementsByTagName("menupopup")[0];
    var theSelectedItem = null;
    xmlHelper.emptyChildren(popup);
    for (var i=0; i<tasks.length; i++) {
      var item = xmlHelper.appendNode(popup, "menuitem", null,
          {"label": tasks[i].name, "value": tasks[i].id});
      if (scratch.task && (tasks[i].id == scratch.task.id))
        theSelectedItem = item;
    }
    if (theSelectedItem) menu.selectedItem = theSelectedItem;
    else if (menu.itemCount > 0) menu.selectedIndex = 0;
    else menu.selectedIndex = -1;
    scratch.stepTree.refresh();
  },
  removeCurrentTask: function  () {
    if (scratch.task) {
     if (prompts.confirm(null, "Please confirm",
          "Are you sure you want to delete the current task?")) {
        scratch.task.detach();
        scratch.save();
        scratch.refreshTaskMenu();
      }
    }
  },
  newTask: function () {
    var taskName = {};
    if(prompts.prompt(null, "Task name", "Name for new task?", taskName, null, {})) {
      scratch.task = scratch.connector.createTask(taskName.value);
      scratch.stepTree.setTask(scratch.task);
      scratch.save();
      scratch.refreshTaskMenu();
     }
  }
};
