#!/usr/bin/perl -w
#
# A sctrip to analyze cproxy dumps
# Mostly for following redirect chains and dumping cookies
# May not work if you have multiple requst chains in the same directory

# TODO
#  - If passed a numerical first argument, take it to be a session number.
#   - Default to the oldest file in /tmp/cf.SESSION.dump
#   - if no dump directory exist, create a world-writable one

use strict;

# Arguments
#  file name (defaults to the oldest in the current dir, usually a good guess)
#  OR a session number (pointing to /tmp/cf.SESSION.dump). If dump dir not there,
#  creates it, and exits.
#  list of interesting cookies, defaulting to all of them

my $filename = $ARGV[0];
if ( !$filename ) {
  $filename = `ls -t | tail -1`;
  chomp($filename);
  print "Starting analysis from the oldest file, $filename \n";
} elsif (  -f $filename ) {
  print "Starting analysis from $filename\n";
} else {
  if ( $filename =~ /^[0-9]+$/ ) {
    my $dir = "/tmp/cf.$filename.dump";
    if ( -d $dir ) {
      chdir ($dir) or die "Could not chdir to $dir: $!\n";
      $filename = `ls -t | tail -1`;
      chomp($filename);
      print "Starting analysis from the oldest file in $dir, $filename \n";
    } else {
      mkdir($dir) or die "Could not create dump dir $filename: $!\n";
      chmod 0777, $dir or die "Could not set permissions for $filename: $!\n";
      print "Created a dump dir $filename. Make your proxy request now\n";
      exit 0;
    }
  }

}



my %filenumbers;
my $filenumber = 1;
my %interesting;
for ( my $i = 1; $i < scalar(@ARGV); $i++) {
  print "$i: Looking out for cookie '" . $ARGV[$i] . "'\n";
  $interesting{$ARGV[$i]} = 1;
}

my %cookies; # cookie name -> whole line
my @allcookies; # all cookies, in the order we see them, with extra info like
                # filenumber=xx; etc. For tracing missing/extra cookies.
while ($filename) { # redirect loop
  print "\n===== $filenumber: $filename =======\n";
  open F, "<$filename" or die "Could not open $filename for reading: $!\n";
  $filenumber++;
  my $section = 0;
  my $status = "";
  my $location = "";
  my $fixedlocation = "";  
  my $nextfile = "";
  my $url = "";
  my $urldomain = "";
  my $urlpath = "";
  while (<F>) {
    if ( $section == 0 ) { # skip preliminaries
      if ( /^URL: http:\/\/(([^\/ ]+)([^?]*).*)/ ) {
      #if ( /^URL: ((.*))/ ) {
        $url = $1;
        $urldomain = $2;
        $urlpath = $3;
      } elsif ( /^Request cookies: (.*)$/ ) {
        my $requestcookies = $1;
        my %seencookies;
        foreach ( split(';',$requestcookies) ) {
          if ( /^ *(([^=]+)=(.*$))/ && ( !%interesting || $interesting{$2} ) ) {
            #print "Checking cookie from browser $1\n" ; # ###
            my $bcookieline = $1;
            my $bcookiename = $2;
            my $bcookievalue = $3;
            $seencookies{$bcookiename} = $bcookieline;
            my $aline = findcookie( $bcookiename, $bcookievalue, $urldomain, $urlpath );
            if ( $aline ) {
              print "OK browser cookie  $bcookieline\n";
              print "  matches $aline\n";
            } else {
              my @cookiematches = ( $requestcookies =~ /$bcookiename=[^ ;]+/g );
              my $matchcount = scalar(@cookiematches);
              if ( $matchcount != 1 ) {
                print "*** Warning *** $matchcount cookies '$bcookiename' ".
                      "in request:\n  ";
                print join("\n  ", @cookiematches ) . "\n"
              }
              my $matches = 0;
              foreach( reverse(@allcookies) ) {
                if ( /^$bcookiename *=/ ) {
                  print "*** Warning *** Browser cookie mismatch $bcookieline\n"
                    unless $matches;
                  $matches ++;
                  print "  $_\n";
                } # TODO - better dump? check what the mismatch is, and say so
              }
              if ( $matches == 0 ) {
                print "NEW browser cookie $bcookieline\n";
              }
            }
          } # interesting cookie
        } # cookie split loop
        # Check for missing cookies!
        foreach( reverse @allcookies ) {
          my $aname = $1 if ( /^ *([^ =]+)/ );
          next if ( %interesting && ! $interesting{$aname} );
          my $adomain = $1 if ( /domain=([^ ;]+)/i );
          next unless ( $urldomain =~ /$adomain$/ );
          my $apath = $1 if ( /path=([^ ;]+)/i );
          next unless ( $urlpath =~ /^$apath/ );
          next if ( $seencookies{$aname} );
          print "*** Warning *** Missing cookie '$aname'. Candidates:\n";
          foreach( reverse(@allcookies) ) {
            if ( /^$aname=/ ) {
              print "  $_\n";
            }
          }
          $seencookies{$aname} = "Missing";
        }
      } elsif ( /^Appending session cookie ( ([^=]+)=.*)$/ ) {
        if ( !%interesting || $interesting{$2} ) {
          print "Cookie from session $1\n";
        }
      } elsif ( /== REQUEST ==/ ) {
        $section ++;
      }
    } elsif ( $section == 1 ) { # Request
      if ( /== RESPONSE ==/ ) {
        $section ++;
      } elsif ( /^GET (.*)$/ ) {
        my $url = $1;
        print "Request to $url\n";
      }
    } elsif ( $section == 2 ) { # response 
      if ( /Response status (.*)$/ ) {
        $status = $1;
        print "== Response: $status\n";
      } elsif ( /Response header Location: (.*)$/ ) {
        $location = $1;
        print "Location: $location\n";
      } elsif ( /Fixed Location to (.*)$/ ) {
        $fixedlocation = $1;
      } elsif ( /Response header Set-Cookie: (.*)$/ ) {
        my $cookieline = $1;
        if ( $cookieline =~ /^([^ =]+)=/ && ( !%interesting || $interesting{$1}) ) {
          print "Response header Set-Cookie $cookieline\n";
          my $cookiename = $1;
          my $saveline = $cookieline;
          $saveline .= "; filenumber=" . ($filenumber-1);
          $saveline .= "; defaultdomain=$urldomain" unless ( $saveline =~ /domain=/i);
          $saveline .= "; defaultpath=$urlpath" unless ($saveline =~ /path=/i);;
          push @allcookies, $saveline;
          if ( $cookies{$cookiename} ) {
            if ( $cookies{$cookiename} eq $cookieline ) {
              print "  Already-seen cookie: $cookieline\n";
            } else {
              print "  *** Warning *** - Differen cookie line\n";
              print "  Received now: $cookieline\n";
              print "  Seen before:  $cookies{$cookiename}\n";
            }
          } else {
            print "  First time cookie:   $cookieline\n";
            $cookies{$cookiename} = $cookieline;
          }
          if ( $cookieline =~ /Domain=\./ ) {
            print "  *** Warning ***  Wildcard domain in cookie, may go wrong!\n";
          }
        }
      } elsif ( /Fixed cookie to: *Set-Cookie:( *([^ =]+).*$)/ ){
        # regexp above works with old and new proxy code
        if ( !%interesting || $interesting{$2}) {
          print "  Fixed cookie to:     $1\n";
        }
      } elsif ( /Add extra cookie: *Set-Cookie: *(([^ =]+).*$)/ ) {
        if ( !%interesting || $interesting{$2}) {
          print "  Add extra cookie:    $1\n";
        }
      } elsif ( /== CONTENT ==/ ) {
        $section++;
        if ( $status =~ /302/ && $location ) {
          $nextfile = $location;
          $nextfile =~ s/^http://; # same code as in cproxy
          $nextfile =~ s/\?.*//;  
          $nextfile =~ s/\//_/g;
          $nextfile =~ s/^_*//;
          if ( $filenumbers{$nextfile} ) {
            $nextfile .= "." . $filenumbers{$nextfile}++;
          } else {
            $filenumbers{$nextfile} = 1;
          }
          if ( -f $nextfile ) {
            print "Continuing in $nextfile\n"; 
          } else {
            print "\nNo next file $nextfile\n";
            $nextfile = "";
          }
        } 
      }
    }
  } # read file loop
  $filename = $nextfile;
} # redirect loop

#### Cookie matching

# Find a cookie in @allcookies, return the line
# Scan from the end of the array, to get the latest with the right name, domain,
# and path.
sub findcookie {
  my $cookiename = shift;
  my $cookievalue = shift;
  my $urldomain = shift;
  my $urlpath = shift;
  foreach( reverse @allcookies ) {
    next unless ( /$cookiename=/ );
    my $adomain = $1 if ( /domain=([^ ;]+)/i );
    next unless ( $urldomain =~ /$adomain$/ );
    my $apath = $1 if ( /path=([^ ;]+)/i );
    next unless ( $urlpath =~ /^$apath/ );
    return $_ if ( /$cookiename=$cookievalue/ );
      # If we found the correct line, but wrong value, don't look for more
    #print "findcookie: ### '$cookievalue' mismatch to $_\n";
    return ""; 
  }
  return "";
}
