var EXPORTED_SYMBOLS = ["Click"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/stepHelper.js');
Components.utils.import('resource://indexdata/util/waitForLoad.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');

var Click = function () {
  this.conf = {};
  this.conf['target'] = ""; // { xpath: "" };
  this.conf['wait'] = {};
  this.conf['wait']['active'] = true;
};

Click.prototype = new Step();
Click.prototype.constructor = Click;

Click.prototype.init = function() {};

Click.prototype.draw = function(surface) {
  xmlHelper.emptyChildren(surface);
  var vbox = xmlHelper.appendNode(surface, "vbox", null, null, null);

  var hbox1 = xmlHelper.appendNode(vbox, "hbox", null, null, null);
  xmlHelper.appendNode(hbox1, "caption", "Target element xpath: ", null, null);
  xulHelper.singleNodeField(hbox1, this, 'target');

  waitForLoad.stepXul(vbox, this.conf['wait']);
};

Click.prototype.run = function (task) {
  let pageDoc = this.getPageDoc();
  let pageWin = this.getPageWindow();
  let nodeSpec = jsonPathHelper.inlineReplaceNodeSpec(this.conf.target, task.data);
  let target = xmlHelper.getElementByNodeSpec(pageDoc, nodeSpec);
  if (target == null) throw new StepError("Target element not found.");
  let clickEvent = pageDoc.createEvent("MouseEvents");
  clickEvent.initMouseEvent("click", true, true, pageDoc.defaultView, 
      0, 0, 0, 0, 0, false, false, false, false, 0, null);
  task.info("sending click event to " + this.renderArgs(), this);
  waitForLoad.wait(task, this.conf.wait, this);
  let ret = target.dispatchEvent(clickEvent);
  if (!ret) task.debug("Dispatched event may have been prevented.");
};

Click.prototype.getClassName = function () {
  return "Click";
};

Click.prototype.getDisplayName = function () {
  return "Click";
};
Click.prototype.getDescription = function () {
  return "Sends a click event to an element.";
};
Click.prototype.getVersion = function () {
  return "1.0";
};

Click.prototype.upgrade = function (confVer, curVer, conf) {
  // can't upgrade if the connector is newer than the step
  if (confVer > curVer) return false;
  if (confVer < 0.5) {
    if (typeof conf['target'] == "string") {
      var oldTarget = conf['target'];
      conf['target'] = {};
      conf['target']['xpath'] = oldTarget;
    } else if (!(typeof conf['target'] == "object" && conf['target']['xpath'])) {
      return false;
    }
  }
  if (confVer < 0.6) {
    if (conf['wait'] !== undefined)
      var oldwait = conf['wait'];
    conf['wait'] = {};
    if (oldwait === undefined) 
      conf['wait']['active'] = false;
    else
      conf['wait']['active'] = oldwait;      
  }
  return true;
};

Click.prototype.renderArgs = function () {
  var target = this.conf.target;
  if (typeof target == "string") return target;
  return target.xpath;
}
