var EXPORTED_SYMBOLS = ["ForEach"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/runtime/Block.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');
Components.utils.import('resource://indexdata/thirdparty/jsonPath.js');
Components.utils.import('resource://indexdata/util/logging.js');

var logger = logging.getLogger();
var ForEach = function () { 
  this.isBreakable = true;
  this.conf = {};
};
ForEach.prototype = new Step();
ForEach.prototype.constructor = ForEach;

ForEach.prototype.init = function(task) {
  //this is ugly but we need to check if the blocks exist in that instance
  if (this.blocks.length == 0) {
    this.blocks.push(new Block(task, 'do', 'do', this));
  }
};

ForEach.prototype.draw = function(surface) {
  let sourceBox = xulHelper.jsonPathField(surface, this, this.conf, 'source',
              "Iterate through objects matching path (key ignored): ");
  let currentBox = xulHelper.jsonPathField(surface, this, this.conf, 'current', 
              "Store current object: ", {path: '$.temp', key: 'current'});
};

// Reset the run state, so we will start looping from the beginning
ForEach.prototype.resetState = function () {
  this.loopcounter = undefined; // clear it for next time we run
}
  
ForEach.prototype.run = function (task, block) {
  this.blocks[0].isCancelled = false;
  let objs = jsonPath(task.data, this.conf.source.path);
  let dest = jsonPath(task.data, this.conf.current.path)[0];
  if ( typeof(this.loopcounter) == "undefined" ) {
    logger.debug("foreach: starting loopcounter from zero, was undefined" );
    this.loopcounter = 0;
  } else {
    logger.debug("foreach loop resuming with iteration " + this.loopcounter );
  }
  while ( (this.loopcounter < objs.length) && !this.blocks[0].isCancelled ) {
    dest[this.conf.current.key] = [objs[this.loopcounter]];
    logger.debug("foreach: about to run iteration " + this.loopcounter );
    this.blocks[0].run(block);
    this.loopcounter++
    if (this.task.isInterrupted) {
      logger.debug("foreach loop interrupted");
      // Tell the block to resume execution with this step, instead of the next
      this.block.nextToRun -= 1;
      return;
    }
    this.blocks[0].resetState();  // clear any possible inner loops for next 
       // iteration. Otherwise, if we have exited due to an exception, those
       // would continue where they left, and not start from scratch.
  }
  this.loopcounter = undefined; // clear it for next time we run
};

ForEach.prototype.getClassName = function () { return "ForEach"; };
ForEach.prototype.getDisplayName = function () { return "For each"; };
ForEach.prototype.getDescription = function () {
  return "Iterate through a list of objects";
};

ForEach.prototype.getVersion = function () {
  return "1.1";
};

ForEach.prototype.getUsedArgs = function () {
   return [];
}

ForEach.prototype.renderArgs = function () {
  return this.conf.source ? 
      this.conf.source.path + '.' + this.conf.source.key + 
      " -> " + this.conf.current.path  + '.' + this.conf.current.key 
    : "";
};
