var EXPORTED_SYMBOLS = ["Log"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/stepHelper.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');
Components.utils.import("resource://indexdata/util/logging.js");

var Log = function () {
  this.conf = {};
  this.conf['message'] = "";
  this.conf['level'] = Level.INFO;
};

Log.levels = [ { name: "DEBUG", value: Level.DEBUG},
               { name: "INFO",  value: Level.INFO},
               { name: "WARN",  value: Level.WARN},
               { name: "ERROR", value: Level.ERROR},
             ];

Log.prototype = new Step();
Log.prototype.constructor = Log;

Log.prototype.init = function() {};

Log.prototype.draw = function(surface) {
  var ns = "http://www.w3.org/1999/xhtml";
  var context = this;

  xmlHelper.appendNode(surface, "span", "Log level:", null, null);
  var levelSelect = xmlHelper.appendNode(surface, "select", null, null, ns);
  for (var i = 0; i < Log.levels.length; i++) {
    var opt = xmlHelper.appendNode(levelSelect, "option", Log.levels[i].name,
                                   { value: Log.levels[i].value }, ns);
    if (Log.levels[i].value == context.conf.level)
      opt.selected = true;
  }
  levelSelect.addEventListener("change", function(e) {
    context.conf['level'] = levelSelect.value;
  }, false);

  xmlHelper.appendNode(surface, "span", "Log message:", null, null);
  var expInput = xmlHelper.appendNode(surface, "input", null,
      { type: "text", value: context.conf['message']}, ns);
  expInput.addEventListener("input", function (e) {
      context.conf['message'] = expInput.value;
  }, false);
  xulHelper.labelField(surface, "Note: You can expand variables " +
        "like {$.input.keyword} ", null );
};

Log.prototype.run = function (task) {
  var message = this.conf['message'];
  task.log(this.conf.level, jsonPathHelper.inlineReplace(message, task.data),
      this);
};

Log.prototype.getClassName = function () {
  return "Log";
};

Log.prototype.getDisplayName = function () {
  return "Log";
};

Log.prototype.getDescription = function () {
  return "Logs a specified message: useful only for debugging.";
};

Log.prototype.getVersion = function () {
  return "0.1";
};

Log.prototype.upgrade = function (confVer, curVer, conf) {
  // can't upgrade if the connector is newer than the step
  if (confVer > curVer)
    return false;
  return true;
};

Log.prototype.renderArgs = function () {
  return Level.getName(this.conf.level) + " " + this.conf.message;
}
