var EXPORTED_SYMBOLS = ["ParseRegex"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/textHelper.js');

if (typeof DEBUG == "undefined") const DEBUG = true;

var ParseRegex = function () {
  this.className = "ParseRegex";
  this.conf = {};
  this.conf["regex"] = "";
  this.conf["resultlist"] = "";
  this.conf["groups"] = {};
  this.conf["target"] = "/html/body";
};
ParseRegex.prototype = new Step();
ParseRegex.prototype.constructor = ParseRegex;

ParseRegex.prototype.init = function() {
};

ParseRegex.prototype.draw = function(surface) {
  xmlHelper.emptyChildren(surface);
  // var vbox = xmlHelper.appendNode(surface, "vbox", null, null, null, false);
  var vbox = xmlHelper.appendNode(surface, "vbox");

  var hbox2 = xmlHelper.appendNode(vbox, "hbox");
  xmlHelper.appendNode(hbox2, "label", "Element to search (defaults to body): ");
  xulHelper.singleNodeField(hbox2, this, "target")

  var hbox1 = xmlHelper.appendNode(vbox, "hbox");
  xmlHelper.appendNode(hbox1, "label", "Regular expression: ");
  var regexInput = xmlHelper.appendNode(hbox1, "textbox", null, {"value":this.conf["regex"], "flex":"1"});

  var hbox3 = xmlHelper.appendNode(vbox, "hbox");
  xmlHelper.appendNode(hbox3, "label", "Result list to populate: ");
  var resultListSelector = xulHelper.resultListSelectField(hbox3, this, "resultlist");
  xmlHelper.appendNode(hbox3, "spacer", null, {"flex": "1"});
  var addGroupButton = xmlHelper.appendNode(hbox3, "button", null, {"label": "Add group"});

  xmlHelper.appendNode(vbox, "separator", null, {"class": "groove-thin"});
  var groupBox = xmlHelper.appendNode(vbox, "separator", null, {"class": "groove-thin"});

  var context = this;

  var g = 0;

  for (key in this.conf["groups"]) {
    var num = parseInt(key.substring(1));
    var name = this.conf["groups"][key];
    g = Math.max(g, num);

    var newGroupHbox = xmlHelper.appendNode(vbox, "hbox");

    xmlHelper.appendNode(newGroupHbox, "label", "Group number: ");
    var groupNum = xmlHelper.appendNode(newGroupHbox, "textbox", null, {"value":num, "originalvalue":num, "width":"40px"});
    xmlHelper.appendNode(newGroupHbox, "label", "Field name: ");
    var resultName = xulHelper.resultSelectField(newGroupHbox, context, null, context.conf["resultlist"]);
    var removeGroupButton = xmlHelper.appendNode(newGroupHbox, "button", null, {"label":"Remove", "value":num});

    resultName.setAttribute("group", num);
    if (name)
      xulHelper.selectMenulistItemWithValue(resultName, name);
    else
      resultName.selectedIndex = 0;

    groupNum.addEventListener("change", function(e) {
      var orig = this.getAttribute("originalvalue");
      context.conf["groups"]["s"+this.value] = context.conf["groups"]["s"+orig];
      delete context.conf["groups"]["s"+orig];
      context.draw(surface);
    }, false);

    resultName.addEventListener("command", function(e) {
      context.conf["groups"]["s"+this.getAttribute("group")] = this.selectedItem.value;
      context.draw(surface);
    }, false);

    removeGroupButton.addEventListener("command", function(e) {
      delete context.conf["groups"]["s"+this.getAttribute("value")];
      context.draw(surface);
    }, false);
  }

  addGroupButton.addEventListener("command", function(e) {
    context.conf["groups"]["s"+(g+1)] = null;
    context.draw(surface);
  }, false);

  resultListSelector.addEventListener("command", function(e) {
    context.draw(surface);
  }, false);

  regexInput.addEventListener("change", function(e) {
    context.conf["regex"] = regexInput.value;
  }, false);

  // surface.appendChild(vbox);
};

ParseRegex.prototype.run = function (task) {
  var output = task.output;
  if (!this.conf["regex"])
    throw new StepError("No regular expression");
  var re = new RegExp(this.conf["regex"], "g");
  if (!re)
    throw new StepError("Regular expression error");
  var match;
  var node;
  var text;

  task.info('Expression: \'' + re.source + '\'', this);

  if (node = xmlHelper.getElementByNodeSpec(this.getPageDoc(), this.conf['target']))
    text = node.innerHTML;
  else
    throw new StepError("cannot retrieve node from xpath "+this.conf['target']);

  task.info("Parsing results...", this);
  // make sure you do not override the previous parse step
  if (typeof output[this.conf["resultlist"]] == 'undefined') {
      output[this.conf["resultlist"]] = [];
  }
  while (match = re.exec(text)) {
    result = {};
    for (key in this.conf["groups"]) {
      //result[this.conf["groups"][key]] = match[parseInt(key.substring(1))];
      //dump("key '" + key + "' value '" + match[parseInt(key.substring(1))] +"'\n");
      var grp = parseInt(key.substring(1));
      var fld = this.conf["groups"][key];
      var val = match[grp];
      val = textHelper.removeWhiteSpace(val);
      //dump("grp: " + grp + " '" + fld + "'  val '" + val + "'\n");
      if (val || !result[fld]) {
        result[fld] = [ val ];
      }
    }
    output[this.conf["resultlist"]].push(result);
  }
};

ParseRegex.prototype.getClassName = function () {
  return "ParseRegex";
};

ParseRegex.prototype.getDisplayName = function () {
  return "Parse by regex";
};

ParseRegex.prototype.getDescription = function () {
  return "Parses results using a regular expression.";
};

ParseRegex.prototype.getVersion = function () {
  return "0.2";
};
