var EXPORTED_SYMBOLS = ["TryCatch"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/runtime/Block.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');
Components.utils.import('resource://indexdata/util/logging.js');
var logger = logging.getLogger();

var TryCatch = function () {
};

TryCatch.prototype = new Step();
TryCatch.prototype.constructor = TryCatch;

TryCatch.prototype.init = function(task) {
  //this is ugly but we need to check if the blocks exist in that instance
  if (this.blocks.length == 0) {
    this.blocks = [];
    this.blocks.push(new Block(task, 'try', 'try', this));
    this.blocks.push(new Block(task, 'catch', 'catch', this));
  }
};


TryCatch.prototype.draw = function(surface) {
  let centredBox = xmlHelper.appendNode(surface, "vbox", null,
    { flex: 1, pack: "center", align: "center" });
  xmlHelper.appendNode(centredBox, 'caption', 
      'Runs "catch" block if any step in "try" fails', { align: "center" });
};

TryCatch.prototype.run = function (task, block) {
  try {
    logger.debug("About to run a block");
    this.blocks[0].run(block);
  } catch (e) {
    logger.warn(e);
    this.blocks[1].run(block);
  }
};

TryCatch.prototype.getClassName = function () {
  return "TryCatch";
};

TryCatch.prototype.getDisplayName = function () {
  return "Try / Catch";
};

TryCatch.prototype.getDescription = function () {
  return 'Runs "catch" block if any step in "try" fails.';
};

TryCatch.prototype.getVersion = function () {
  return "1.0";
};
TryCatch.prototype.getUsedArgs = function () { return []; }
TryCatch.prototype.renderArgs = function () { return ''; };
