var EXPORTED_SYMBOLS = ["app"];
var xulHelper = null;

// Only initialise the xulHelper object in the builder TODO: proper separation of app
let xulAppInfo = Components.classes["@mozilla.org/xre/app-info;1"].getService(Components.interfaces.nsIXULAppInfo);
if (xulAppInfo.name !=="ConnectorFramework") { /* BEGIN BUILDER ONLY WRAPPER */

Components.utils.import("resource://indexdata/util/Subject.js");
Components.utils.import("resource://indexdata/runtime/ConnectorTemplate.js");
Components.utils.import("resource://indexdata/runtime/Connector.js");
Components.utils.import('resource://indexdata/util/Highlighter.js');
Components.utils.import('resource://indexdata/util/logging.js');
Components.utils.import("resource://gre/modules/AddonManager.jsm");

const APP_ID = "cfbuilder@indexdata.com";

var logger = logging.getLogger();
var IS_EXTENSION = true;
var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"]
  .getService(Components.interfaces.nsIWindowMediator);

/**
 * This class contains all global vars used throuoghout the application
 * (open connector, selected task) everything that needs to be referred from
 * multile windows should end-up here. This class is also used for app-wide
 * "message-bus" working in a publish/subscribe model (provided by the Subject
 * util class), you can do cross-window communication/event-notification by using
 * its capabilites.
**/
app = new Subject([
    "id",
    "addon",
    "version",
    "mainWindow",
    "template",
    "templateFile",
    "activeTest",
    "connector",
    "selectedTask",
    "selectedStep",
    "lastOpened",
    "canSave",
    "saveTimer",
    "stickyNewStep",
    "listAllSteps",
    "highlighter",
    "quit",
    "fullqueryEdited"
  ]);

app.set("id", APP_ID);
AddonManager.getAddonByID(app.id, function(addon) {
  app.set("addon", addon);
  try {
    // prefer version from IDMETA if found (git checkout)
    let file = addon.getResourceURI('/').QueryInterface(Components.interfaces.nsIFileURL).file;
    if (file && file.parent) {
      file = file.parent;
      file.append('IDMETA');
      if (file.isFile()) {
        let stream = Components.classes["@mozilla.org/network/file-input-stream;1"]
          .createInstance(Components.interfaces.nsIFileInputStream);
        stream.init(file, 0x01, 0444, 0);
        stream.QueryInterface(Components.interfaces.nsILineInputStream);
        let line = {};
        let hasmore = true;
        while (hasmore) {
          hasmore = stream.readLine(line);
          let m = line.value.match(/^VERSION=(.*)$/);
          if (m) {
            app.set("version", m[1]);
          }
        }
        stream.close();
      }
    }
  } catch (e) {
  }
  // otherwise use version from install.rdf
  if (!app.version) app.set("version", addon.version);
});
// Block so we know we have the addon when we load the auto-saved connector
Components.classes["@mozilla.org/thread-manager;1"]
  .getService(Components.interfaces.nsIThreadManager)
  .currentThread.processNextEvent(false);

app.saveTimer = null;
app.listAllSteps = false;
try {
  let prefs = Components.classes["@mozilla.org/preferences-service;1"]
    .getService(Components.interfaces.nsIPrefService)
    .getBranch("indexdata.cf.");
  app.stickyNewStep = prefs.getBoolPref("stickyNewStep", app.stickyNewStep);
} catch (e) { 
  app.stickyNewStep = false;
}
app.tabReuse = {};

// Observer -- right now just for quit
let observerService = Components.classes["@mozilla.org/observer-service;1"]
  .getService(Components.interfaces.nsIObserverService);
observerService.addObserver(app, "quit-application", false);

app.observe = function (subject, topic, data) {
  if (topic === "quit-application") app.notify("quit");
};

app.openResAndDo = function (path, onres) {
  if (typeof path != "object")
    throw new Error("path must be an array");
  if (typeof onres != "function")
    throw new Error("onres arg must be a function");
  //FF 3, simulute async API
  var em = Components.classes["@mozilla.org/extensions/manager;1"];
  if (em) {
    logger.debug("Found nsIExtensionManager..");
    em = em.getService(Components.interfaces.nsIExtensionManager);
    var file = em.getInstallLocation(APP_ID).getItemFile(APP_ID, "");
    for (var i=0; i<path.length; i++) {
      file.append(path[i]);
    }
    logger.debug("Opening resource at "+file.path);
    onres(file);
  } else {
    Components.utils.import("resource://gre/modules/AddonManager.jsm");
    AddonManager.getAddonByID(APP_ID, function(addon) {
      var file = addon.getResourceURI(path.join('/'))
      .QueryInterface(Components.interfaces.nsIFileURL).file;
      logger.debug("Opening resource at "+file.path)
      onres(file);
    });
  }
};

app.disableApp = function () {
  var man = Components.classes["@mozilla.org/extensions/manager;1"];
  if (man) {
    man = man.getService(Components.interfaces.nsIExtensionManager);
    man.disableItem(app.id);
  } else {
    Components.utils.import("resource://gre/modules/AddonManager.jsm");
    AddonManager.getAddonByID(app.id, function(addon) {
      addon.userDisabled = true;
    });
  }
};

app.getBrowserWidget = function (windowCtx) {
  try {
    IS_EXTENSION = true;
    return windowCtx.top.getBrowser()
      .browsers[windowCtx.top.getBrowser().mTabBox.selectedIndex];
  } catch (e) {
    IS_EXTENSION = false;
    logger.debug(e);
    return windowCtx.document.getElementById("pageBrowser");
  }
};

app.reloadTabIfOpen = function (url, bringToFront) {
  var tabbrowser = this.mainWindow.gBrowser;
  for (var i=0; i<tabbrowser.browsers.length; i++) {
    if (url == tabbrowser.getBrowserAtIndex(i).currentURI.spec) {
      var tab = tabbrowser.tabContainer.childNodes[i];
      if (bringToFront === true)
        tabbrowser.selectedTab = tab;
      tabbrowser.reloadTab(tab);
      return true;
    }
  }
  return false;
};

app.openOrReuseTab = function (url) {
  var tabbrowser = this.mainWindow.gBrowser;
  var exists = false;
  if (this.tabReuse[url] && this.tabReuse[url].linkedBrowser) {
    // we've opened this before so lets switch to that tab if
    // it's still around and pointing at vaguely the same url
    if (this.tabReuse[url].linkedBrowser.currentURI
      && this.tabReuse[url].linkedBrowser.currentURI.spec.split("?")[0]
      == url.split("?")[0]) {
      exists = true;
      tabbrowser.selectedTab = this.tabReuse[url];
    }
  }

  if (!exists) {
    for (var i=0; i<tabbrowser.browsers.length; i++) {
      if (url == tabbrowser.getBrowserAtIndex(i).currentURI.spec) {
        // this url is already open in the window with the builder,
        // we should just switch to it instead of opening a new one.
        tabbrowser.selectedTab = tabbrowser.tabContainer.childNodes[i];
        this.tabReuse[url] = tabbrowser.selectedTab;
        exists = true;
        break;
      }
    }
  }
  if (!exists) {
    tabbrowser.selectedTab = tabbrowser.addTab(url, null, null, null, null);
    this.tabReuse[url] = tabbrowser.selectedTab;
  }
};

app.openDefaultTemplate = function () {
  //builder pref, id branch
  var prefs = Components.classes["@mozilla.org/preferences-service;1"]
    .getService(Components.interfaces.nsIPrefService)
    .getBranch("indexdata.cf.");
  var file = app.openResAndDo(['templates',
      prefs.getCharPref('defaulttemplate')],
      function (file) {
        app.loadTemplate(file);
      });
};

app.loadTemplate = function (file) {
  app.template = new ConnectorTemplate();
  app.templateFile = file;
  logger.debug("Loading template from " + file.path);
  try {
    app.template.loadFromFile(file);
    app.connector = null;
    app.notify("template");
    app.newConnector();
  } catch (e) {
    logger.debug(e);
    app.popupError("Cannot open template: " + e.message + " in " + e.fileName + ":" + e.lineNumber);
    return;
  }
};

app.popupError = function (errorMsg) {
  app.mainWindow.alert(errorMsg);
};

app.saveFileAs = function (winCtx) {
  var proposedName = "new_connector";
  if (app.connector.metaData.origin) {
    proposedName = app.connector.metaData.origin.replace(/.*[\/\\]/, "")
      .replace(/\..*/,"");
  } else if (app.connector.metaData.title) {
    proposedName = app.connector.metaData.title.toLowerCase()
      .replace(/\s+/g, '_');
  }
  app.openBrowseDialog(winCtx, "Choose file to save connector...",
    "save", function (fp) {
      try {
        app.connector.saveConfToFile(fp.file);
      } catch (e) {
        logger.debug(e);
        app.popupError("Cannot save file: " + e.message);
        return;
      }
      app.set("canSave", false);
      app.set("lastOpened", fp.file);
    }, {"name" : "CF Connector", "ext" : "*.cf"}, null, proposedName, 'cf');
};

app.saveFile = function (windowCtx) {
  if (app.lastOpened == null) return app.saveFileAs(windowCtx);
  try {
    app.connector.saveConfToFile(app.lastOpened.path);
  } catch (e) {
    logger.debug(e);
    app.popupError("Cannot save file: " + e.message);
    return;
  }
  app.set("canSave", false);
};

app.loadFile = function (windowContext) {
  if (!app.promptUnsaved())
    return false;
  app.openBrowseDialog(windowContext, "Choose connector file..",
    "load", function (fp) {
      app.connector = new Connector(app.template);
      if (app.version) app.connector.builderVersion = app.version;
      try {
        app.connector.loadConfFromFile(fp.file.path);
      } catch (e) {
        logger.debug(e);
        app.popupError("Cannot open file: " + e.message);
        return;
      }
      // use test session values for builder
      // * only on load so they persist between task invocations
      app.connector.useSessionTestValues();
      var bWin = app.getBrowserWidget(windowContext);
      app.set("lastOpened", fp.file);
      app.notify("connector");
      app.set("canSave", false);
    }, {"name" : "CF Connectors", "ext" : "*.cf"}, null, null, 'cf'
  );
};

app.newConnector = function () {
  if (!app.promptUnsaved())
    return false;
  app.set("canSave", false);
  app.connector = new Connector(app.template);
  if (app.version) app.connector.builderVersion = app.version;
  app.lastOpened = null;
  for (var key in app.template.requirements) {
    logger.debug(" - creating task from requirements for '"+key+"'");
    var task = app.connector.createTask(key);
    task.createDefaultTests();
  }
  app.connector.metaData = {};
  for (var i=0; i<app.template.metaData.length; i++) {
    var name = app.template.metaData[i].name;
    app.connector.metaData[name] = "";
  }
  app.notify("connector");
  app.notify("lastOpened");
};

app.promptUnsaved = function () {
  var prompts = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
    .getService(Components.interfaces.nsIPromptService);
  if (!app.canSave || prompts.confirm(null, "Please confirm", "Discard unsaved changes?"))
    return true;
  else
    return false;
}

app.changeTemplate = function (winCtx) {
  if (!app.promptUnsaved())
    return false;
  var initDir = null;
  app.openResAndDo(["templates"],
    function (initDir) {
      app.openBrowseDialog(winCtx, "Choose template file..", "load",
        function (fp) {
          app.loadTemplate(fp.file, winCtx);
          app.set("lastOpened", null);
        },
        {"name" : "CF Templates", "ext" : "*.cft"}, initDir,
        null, 'cft');
    }
  );
};

app.openBrowseDialog = function (winCtx, winName, mode, onSelect, ftype,
                      initDir, defaultFileName, defaultExtension) {
  const nsIFilePicker = Components.interfaces.nsIFilePicker;
  var fp = Components.classes["@mozilla.org/filepicker;1"]
    .createInstance(nsIFilePicker);
  fp.init(winCtx, winName,
      mode === "load" ? nsIFilePicker.modeOpen : nsIFilePicker.modeSave);
  if (ftype)
    fp.appendFilter(ftype["name"], ftype["ext"]);
  if (initDir)
    fp.displayDirectory = initDir;
  if (defaultFileName)
    fp.defaultString = defaultFileName;
  if (defaultExtension)
    fp.defaultExtension = defaultExtension;
  //one would think that this coould be easily done with do/while
  //ut FF doesn't like it
  var showFp = function () {
    var confirmed = true;
    var rv = fp.show();
    if (rv == nsIFilePicker.returnOK || rv == nsIFilePicker.returnReplace) {
      //now check if the defaultExtension was really appended
      if (defaultExtension &&
          fp.file.path.indexOf(defaultExtension, fp.file.path.length -
            defaultExtension.length) == -1) {
        var prompts =
        Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
          .getService(Components.interfaces.nsIPromptService);
        confirmed = prompts.confirm(null, "Please confirm",
          "You are about to save the file without its default extension (."
          +defaultExtension+") and your platform does not append extensions "
          +"automatically. It may be impossible to re-open the file without "
          +"renaming it. Are you sure you want to continue?");
      }
      if (confirmed) {
        onSelect(fp);
        return;
      } else {
        showFp();
        return;
      }
    }
  }
  showFp();
};

app.saveState = function (timer) {
  var xs = Components.classes["@mozilla.org/xmlextras/xmlserializer;1"].
    createInstance(Components.interfaces.nsIDOMSerializer);
  var prefs = Components.classes["@mozilla.org/preferences-service;1"]
    .getService(Components.interfaces.nsIPrefService)
    .getBranch("indexdata.cf.");
  prefs.setCharPref("state.connector",
    xs.serializeToString(app.connector.saveConf()));
  prefs.setComplexValue("state.templatefile",
    Components.interfaces.nsILocalFile, app.templateFile);
  if (app.lastOpened && app.lastOpened.path)
    prefs.setComplexValue("state.lastopenedfile",
      Components.interfaces.nsILocalFile, app.lastOpened);
  else
    prefs.setCharPref("state.lastopenedfile", "");
  prefs.setBoolPref("state.cansave", app.canSave);
  app.saveTimer = null;
  logger.debug("Connector state saved.");
};

app.saveStateIfYouHaventRecently = function () {
  if (app.connector && app.saveTimer === null) {
    app.saveTimer = Components.classes["@mozilla.org/timer;1"]
          .createInstance(Components.interfaces.nsITimer);
    var timerCb = { notify: app.saveState};
    app.saveTimer.initWithCallback(timerCb, 2000,
      Components.interfaces.nsITimer.TYPE_ONE_SHOT);
  }
};

app.subscribe("connector", app.saveStateIfYouHaventRecently);
app.subscribe("canSave", app.saveStateIfYouHaventRecently);
app.subscribe("template", app.saveStateIfYouHaventRecently);
app.subscribe("quit", app.saveState);

app.loadState = function () {
  var prefs = Components.classes["@mozilla.org/preferences-service;1"]
    .getService(Components.interfaces.nsIPrefService)
    .getBranch("indexdata.cf.");
  try {
    var parser = Components.classes["@mozilla.org/xmlextras/domparser;1"]
      .createInstance(Components.interfaces.nsIDOMParser);
    var connectorString = prefs.getCharPref("state.connector")
    var templateFile = prefs.getComplexValue("state.templatefile", Components.interfaces.nsILocalFile);
    var lastOpened = prefs.getCharPref("state.lastopenedfile");
    if (lastOpened)
      lastOpened = prefs.getComplexValue("state.lastopenedfile", Components.interfaces.nsILocalFile);
    else
      lastOpened = null;
    var canSave = prefs.getBoolPref("state.cansave")

    app.loadTemplate(templateFile);
    app.connector.loadConf(parser.parseFromString(connectorString, "text/xml"));
    app.connector.useSessionTestValues();
    app.set("canSave", canSave);
    app.set("lastOpened", lastOpened);
    app.notify("connector");
    return true;
  } catch (err) {
    logger.debug(err);
    return false;
  }
};

app.newHl = function (doc, cb) {
  if (this.highlighter) {
    // highlighter doc has already been gc'd if we've changed pages
    if (doc === this.highlighter.doc) this.highlighter.destroy();
    this.highlighter = null;
  }
  var hl = new Highlighter(doc, cb);
  this.highlighter = hl;
  app.subscribe("selectedStep", function () {
    if (hl) {
      hl.destroy();
      hl = null;
    }
  });
  return this.highlighter;
};

// Set proxy to proxy from init, if available.
// Remove proxy if set.
app.toggleProxy = function (e) {
  let prefs = Components.classes["@mozilla.org/preferences-service;1"]
    .getService(Components.interfaces.nsIPrefService).getBranch("network.proxy.");
  if (prefs.prefHasUserValue("type")) var type = prefs.getIntPref("type");

  // If proxy enabled, disable and update button.
  if (type && type > 0) {
    prefs.setIntPref("type", "0");
    e.target.setAttribute("label", "Proxy?");
    return;
  }

  // Otherwise see if we can find an init task w/proxyip
  let ipRegex = /^([0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3})(?:\:([0-9]{1,5}))?$/;
  let initTasks = this.connector.findTasks('init');
  if (!(Array.isArray(initTasks) && (initTasks.length > 0))) return;
  let tests = initTasks[0].getTests();
  if (!(Array.isArray(tests) && (tests.length > 0))) return;
  let proxyip = this.connector.data.session.proxyip;
  if (!proxyip) proxyip = tests[0].getArg("proxyip");
  let result = ipRegex.exec(proxyip);
  if (!(Array.isArray(result) && (result.length > 1))) return;
  let ip = result[1];
  let port = result[2] || "80";
  prefs.setCharPref("http", ip);
  prefs.setIntPref("http_port", parseInt(port));
  prefs.setIntPref("type", 1);
  e.target.setAttribute("label", "Proxied.");
  return;
};

// Window loading

app.newStepWindow = function () {
  app.mainWindow.open('chrome://cfbuilder/content/step_browser.xul',
          'newStepWindow', 'chrome,width=240,height=512,resizable=yes').focus();
};

app.newScratchWindow = function () {
  app.mainWindow.open('chrome://cfbuilder/content/scratch.xul',
          'scratchWindow', 'chrome,width=420,height=600,resizable=yes').focus();
};

app.newMetaWindow = function () {
  app.mainWindow.openDialog('chrome://cfbuilder/content/meta_editor.xul', 'metaEditor', 'chrome,resizable=yes').focus();
};

app.newTaskWindow = function () { app.mainWindow.open('chrome://cfbuilder/content/new_task.xul',
          'newTaskWindow', 'chrome,width=300,height=400,resizable=yes').focus();
};

app.newTestEditWindow = function () {
  app.mainWindow.open('chrome://cfbuilder/content/test_editor.xul', 'testEditor', 'chrome,resizable=yes').focus();
};

app.newJsonEditWindow = function (obj, cb, windowName) {
  let win = app.mainWindow.open('chrome://cfbuilder/content/jsoneditor/index.html',
    windowName, 'chrome, width=800, height=600,resizable=yes');
  win.addEventListener('pageshow', function () {
    this.formatter.set(obj);
    this.main.formatterToEditor();
  }, false);
  win.addEventListener('close', function () {
    cb(this.formatter.get());
  }, false);
};

} /* END BUILDER ONLY WRAPPER */
