var EXPORTED_SYMBOLS = ["io","StringOutputStream"];

//flags
const PR_RDONLY = 0x01;
const PR_WRONLY = 0x02;
const PR_RDWR = 0x04;
const PR_CREATE_FILE = 0x08;
const PR_APPEND = 0x10;
const PR_TRUNCATE = 0x20;
const PR_SYNC = 0x40;
const PR_EXCL = 0x80;

//classes and interfaces
const Cc = Components.classes;
const Ci = Components.interfaces;

const fileClass = Cc["@mozilla.org/file/local;1"];
const fileIf = Ci.nsILocalFile;

const fosClass = Cc["@mozilla.org/network/file-output-stream;1"];
const fosIf = Ci.nsIFileOutputStream;

const cosClass = Cc["@mozilla.org/intl/converter-output-stream;1"];
const cosIf = Ci.nsIConverterOutputStream;

var ConsoleOutputStream = function () {
  this.str = "";
};
ConsoleOutputStream.prototype = {
  write: function (buffer, count) {
    this.str += buffer;
  },
  flush: function () {
    dump(this.str);
    this.str = "";
  },
  close: function () {
  }
};


var StringOutputStream = function () {
  this.init();
};
StringOutputStream.prototype = {
  init: function () {
    this.str = "";
  },
  write: function (buffer, count) {
    this.str += buffer.substr(0,count);
  },
  flush: function () {
  },
  close: function () {
  }
};

var io = {
  //open file handle
  file: function (path) {
    file = Components.classes["@mozilla.org/file/local;1"]
        .createInstance(Components.interfaces.nsILocalFile);
    file.initWithPath(path);
    if (file.exists() === false) {
      try {
        file.create(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 0644);
      } catch (e) {
        dump(e.message + "\n");
        throw new Error("cannot create file (possibly access denied)");
      }
    }
    return file;
  },
  // open file output stream, given a file handle or a path
  fos: function (file, mode) {
    // file is a path, open handle
    if (typeof file == "string") {
      file = io.file(file);
    }
    //create output stream on the file handle          
    var fos = Components.classes["@mozilla.org/network/file-output-stream;1"]
      .createInstance(Components.interfaces.nsIFileOutputStream);
    var flags = PR_WRONLY | PR_CREATE_FILE | PR_TRUNCATE;
    if (mode === "a")
      flags = PR_WRONLY | PR_APPEND;
    try {
      fos.init(file, flags, 0644, 0);
    } catch (e) {
      dump(e.message + "\n");
      throw new Error("write error (possibly access denied)");
    }
    return fos;
  },
  // write to file, output stream or path
  write: function (fos, data) {
    //if (!(fos instanceof fosIf)) fos = io.fos(fos);
    var cos = Components.classes["@mozilla.org/intl/converter-output-stream;1"]
      .createInstance(Components.interfaces.nsIConverterOutputStream);
    //3-arg bufferSize, 4-arg substitute character
    cos.init(fos, "UTF-8", 0, 0x0000);
    cos.writeString(data);
    cos.close();
  },
  // this is an example of what not to do
  writeBad: function (fos, data) {
    fos.write(data, data.length);
    fos.close();
  }
}
