var EXPORTED_SYMBOLS = ["objHelper"];

Components.utils.import('resource://indexdata/util/xmlHelper.js');

var objHelper = {
  objectFromXml: function (node) {
    switch(node.getAttribute("type")) {
      case "null": return null;
      case "bool": return node.textContent == "true";
      case "number": return Number(node.textContent);
      case "string": return node.textContent;
      case "array":
        var arr = [];
        for (var i=0; i<node.childNodes.length; i++) {
          var child = node.childNodes[i];
          if (child.nodeType == 1 && child.nodeName == "item")  // Node.ELEMENT_NODE == 1
            arr.push(objHelper.objectFromXml(child));
        }
        return arr;
      case "object":
        var obj = {};
        for (var i=0; i<node.childNodes.length; i++) {
          var child = node.childNodes[i];
          if (child.nodeType == 1) //Node.ELEMENT_NODE
            obj[child.nodeName] = objHelper.objectFromXml(child);
        }
        return obj;
      default: throw new SyntaxError("Cannot parse: unkown type, " +
          " at node '" + node.nodeName + "' :" +
          "'" + node.getAttribute("type") +"' " );
    }
  },
  objectToXml: function (name, obj, node) {
    switch (typeof obj) {
      case "boolean":
        return xmlHelper.appendNode(node, name, obj, {"type": "bool"});
      case "number":
        return xmlHelper.appendNode(node, name, obj, {"type": "number"});
        return;
      case "string":
        return xmlHelper.appendNode(node, name, obj, {"type": "string"});
        return;
      case "object":
        var newNode;
        //null
        if (!obj) {
          return xmlHelper.appendNode(node, name, null, {"type": "null"});
        //array
        } else if (typeof obj.length === 'number' && 
            !obj.propertyIsEnumerable('length')) {
          var child = 
          xmlHelper.appendNode(node, name, null, {"type": "array"});
          for (var i=0; i < obj.length; i++) {
            objHelper.objectToXml("item", obj[i], child);
          }
          return child;
        // hash
        } else {
          var child = 
          xmlHelper.appendNode(node, name, null, {"type":"object"});
          for (var key in obj) {
            objHelper.objectToXml(key, obj[key], child);
          }
          return child;
        }
        return;
      }
    },

    loadProperties: function (node) {
      var properties = {};
      for (var i=0; i<node.childNodes.length; i++) {
        var cur = node.childNodes[i];
        if (cur.nodeName.toLowerCase() === 'property' && cur.getAttribute('name')) {
          // straight string value, for backwards compatibility
          if (cur.getAttribute('value'))
            properties[cur.getAttribute('name')] = cur.getAttribute('value');
          // objhelper
          else if (cur.getAttribute('type'))
            properties[cur.getAttribute('name')] = objHelper.objectFromXml(cur);
        }
      }
      return properties;
    },
    
    saveProperties: function (obj, node) {
      for (var p in obj) { 
        var propNode = objHelper.objectToXml("property", obj[p], node);
        propNode.setAttribute("name", p);
      }          
    }
}
