#!/bin/sh
# assumes pwd is engine/src

DIR=`dirname $0`            # ../../connectors/cf-zserver-regression
PLAINDIR=`basename $DIR`    # cf-zserver-regression

echo "running $0"
GRET=0
: ${diff_opt="-u"}
: ${REGRESSION_FATAL=false}

CONNECTORLIST=`cd $DIR/..; ls *.cf $PLAINDIR/*.cf`
for C in $CONNECTORLIST
do
    CNAME=`basename $C .cf`
    CDIR=`dirname $C`
    if [ $CDIR = "." ]
    then
      CONNECTOR=$CNAME
    else
      CONNECTOR=$CDIR/$CNAME
    fi

    RET=0
    QRYFILE=$DIR/$CNAME.query
    # Make sure we have a query file, with plain "water" if need be
    test -f $QRYFILE ||
      echo "@attr 1=1016 @attr 2=3 @attr 3=3 @attr 4=2 "\
           "@attr 5=100 @attr 6=1 water" > $QRYFILE
    LOG=$DIR/$CNAME.mp.log
    rm -f $LOG
    while read QRY1
    do  # for each line in the file
      echo "======================" >> $LOG
      QRY=`echo $QRY1 | sed 's/^#.*$//' `  # strip comment lines
      echo $QRY1  >> $LOG
      if [ ! -z "$QRY" ]
      then 
        zoomsh "connect localhost:9070" "set databaseName $CONNECTOR" \
                  "set count 2" "search $QRY" "quit" >>$LOG
        test $? -ne 0 && RET=1
      fi
    done < $QRYFILE
    if test -f $DIR/$CNAME.out; then
	diff $diff_opt $DIR/$CNAME.out $LOG
	if test $? -ne 0; then
	    echo "  $CNAME: differ (MP)"
            GRET=1
	else
	    echo "  $CNAME: OK (MP)"
	fi
    else
        echo "   $CNAME: Making for the first time"
        cp $LOG $DIR/$CNAME.out
    fi
  
done # connector loop

exit $GRET
