/* This file is part of the Connector Framework
 * Copyright (C) 2008-2013 Index Data
 * See the file LICENSE for details.
 */
/**
 * \file cf_embed.h
 * \brief CF_Embed header
 */
#include <unistd.h>
#include <pthread.h>
#include <glib.h>
#include <gdk/gdkx.h>
#include <yaz/wrbuf.h>
#include <yaz/timing.h>
#include <string>
#include "cf_logger.h"
#include "cf_display.h"
#include "nsStringAPI.h"

class ConnectorWrap;

class CF_Engine;
class MozApp;
/**
 * Connector Session Embedding Implementation
 */
class CF_Embed : public CF_Logger // default logger
{
    friend class CF_Engine;
public:
    CF_Embed(int argc, char **argv, const char *module_path,
             const char *app_path, const char *profile_path,
             const char *proxy, const char *loglevel,
             CF_Logger *logger, int fd);
    ~CF_Embed();
    bool spawn_thread(std::string &err_msg);
    bool spawn_fork(std::string &err_msg, int fd, int capt_stdout);
    const char *get_module_path();
    const char *get_app_path();
    void main();
    void input_handler(GIOChannel *source);
    void browser_ready(ConnectorWrap *connector);
    void browser_failure(const char *msg);
    void result_handler(bool success, const char *str);
    bool wait_result_parent(const char **output, int timeout_ms, bool *sys_err);
    void get_result_parent(const char *default_msg, const char **output);
    void load_cf_parent(const char *cf_file, const char *session_json = 0);
    void save_cf_parent(const char *cf_file);
    void run_script_parent(const char *script_file);
    void run_task_parent(const char *taskName, bool optional, const char *input,
                         const char **output);
    bool run_tests_parent(const char *task_order);
    bool unit_test_parent(const char *name);
    CF_Logger *logger; // passed logger in constructor or itself
    void printf(const char *module, int level, const char *fmt, ...);
private:
    bool wait_init_handshake(std::string &error_msg);
    void copy_initial_js_files(const char *a_profile_path,
                               const char *a_app_path,
                               const char *loglevel);
    void write_response(const void *buf, size_t count);
    bool screen_shot_parent(const char *filename);
    void dom_string_parent(char **retval);
    int write_request(WRBUF w);
    char *module_path;
    char *app_path;
    char *profile_path;
    int profile_temp;
    char *proxy_host;
    int proxy_port;
    int request_fd[2];
    int response_fd[2];
    pid_t pid;
    ConnectorWrap *connector;
    WRBUF result_wrbuf;
    int argc;
    char **argv;
    pthread_t child_thread;
    bool using_threads;
    MozApp *mozApp;
    yaz_timing_t task_timing;
    WRBUF current_task;
    XID main_window_xid;
    CF_Display display;
};

CF_Embed *get_CF_Embed();

/*
 * Local variables:
 * c-basic-offset: 4
 * c-file-style: "Stroustrup"
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=4 tabstop=8 expandtab
 */

