/* This file is part of the Connector Framework
 * Copyright (C) 2008-2013 Index Data
 * See the file LICENSE for details.
 */
/**
 * \file cf_metadata.h
 * \brief CF metadata
 */

#ifndef CF_METADATA_H
#define CF_METADATA_H

#include <yaz/wrbuf.h>
#include <libxml/parser.h>

class CF_Metadata {
public:
    CF_Metadata();
    ~CF_Metadata();
    bool parse_cf(const char *fname);
    const char *get(const char *type);
private:
    bool parse_doc(xmlDoc *doc);
    WRBUF m_flags;
};

#endif
/*
 * Local variables:
 * c-basic-offset: 4
 * c-file-style: "Stroustrup"
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=4 tabstop=8 expandtab
 */

