#!/bin/bash
#
# Loads connectors from arguments into engine and rewrites back to the same file.
# Imports template via loadSearchTemplate.js


# Get directory where this script lives. Thanks to:
# http://stackoverflow.com/questions/59895/can-a-bash-script-tell-what-directory-its-stored-in
THIS_PATH="$( cd -P "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"


# Establish base CF path
if test -z "$CF_BASE_PATH"; then
  CF_BASE_PATH="$(cd ${THIS_PATH}/../.. && pwd)"
fi


# Find cfrun binary
CFRUN="./cfrun"

if test ! -x "$CFRUN"; then
  CFRUN=`which cfrun`
fi

if test -z "$CFRUN"; then
  echo "ERROR: cfrun binary not found in path or current directory" >&2
  exit 0
fi


# Find loadSearchTemplate.js script
TMPLJS="$(pwd)/loadSearchTemplate.js"

if test ! -r "$TMPLJS"; then
  TMPLJS="${THIS_PATH}/loadSearchTemplate.js"
fi

if test ! -r "$TMPLJS"; then
  echo "ERROR: loadSearchTemplate.js not found in current directory or directory with this script" >&2
  exit 0
fi


# Set up display
if test "$XVFB"; then
  : ${CF_LOGS_DIR="./logs"}

  if ! which Xvfb >/dev/null; then
    echo "WARNING: Xvfb (Virtual Framebuffer fake X server) not found!"
  fi

  : ${XVFB_SCREEN="-screen 0 800x600x24"}
  echo localhost > ${CF_LOGS_DIR}/Xvfb.hosts
  ( Xvfb :1 $XVFB_SCREEN -auth ${CF_LOGS_DIR}/Xvfb.hosts > ${CF_LOGS_DIR}/Xvfb.out 2>&1 & )
  export DISPLAY=:1.0
fi

if test -z "$DISPLAY"; then
  echo "WARNING: display not set" >&2
fi


# Queue commands and launch cfrun

# Load template
CFRUN_COMMANDS="script ${TMPLJS}\n"

# Load and save connectors
for connector_path in $@; do
  CFRUN_COMMANDS="${CFRUN_COMMANDS}cf ${connector_path}\n"
  CFRUN_COMMANDS="${CFRUN_COMMANDS}write ${connector_path}\n"
done

CFRUN_COMMANDS="${CFRUN_COMMANDS}quit"


echo -e "${CFRUN_COMMANDS}"

echo -e "${CFRUN_COMMANDS}" | CF_BASE_PATH="${CF_BASE_PATH}" "${CFRUN}"
