#!/bin/sh
# Copyright (c) 2011-20123IndexData ApS. http://indexdata.com
#
# cf-bisect-connector-upgrade - find by git binary search the change 
#                               that break a connector in step upgrade
#
# The script will report any connector changes, and if there is one 
# exit with non-zero value.
# 
# Note: if the change is good you have to update the test connector
# for further usage.
#
# git bisect start <bad> <good>
# git bisect run ~/proj/cf/bin/cf-bisect-upgrade.sh
#
# for more informations, see the git-bisect man page
#


# for git-bisect, we need the latest cf master checkout
: ${cf_master_checkout=false}

if $cf_master_checkout; then
    cf_home=$(pwd)
else
    cf_home=$HOME/proj/cf
fi

# which connector to test
: ${connector="$cf_home/connectors/upgrade/commentary_magazine.11.cf"}

set -e

if [ ! -e .git/config ]; then
    echo "You need to run this command from the toplevel of the working tree." >&2 
    exit 1
fi

tempfile=$(tempfile -s .cf -p cfup-)
cp -f $connector $tempfile

(
# compile engine
cd engine/src

if ! $cf_master_checkout; then
    make -s distclean
    make -s -j4
fi
mkdir -p logs

XVFB=1 ./rewrite-connector.sh $tempfile > logs/rewrite.log 2>&1
if ! $cf_master_checkout; then
  $cf_home/../cf-repo/bin/pretty-xml.pl $tempfile
fi
)

if diff $connector $tempfile; then
  rm -f $tempfile
else
  echo "see $tempfile"
  exit 1
fi

