#!/bin/sh
# Copyright (c) 2010-2012 by Index Data ApS. http://www.indexdata.com
#
# cf-bootstrap.sh - build the engine with the lastest Index Data tools from GIT 
#                   repo in a sandbox and run full tests
#
# To install devel tools, see the list of tools on
# http://twiki.indexdata.dk/cgi-bin/twiki/view/ID/CFRepoInstallation

# fail on error
set -e

dir=$(mktemp -d -t cf-bootstrap.XXXXXXXX)
cd $dir

: ${make=make}
: ${make_opt="-s -j4"}
: ${debug=""}

# see ./cf-build-devel.sh how to test a CF branch or GIT ID,
#cf_branch=""
#cf_git_id=""

# cross compiling flags for MacOS
case `uname` in
    FreeBSD ) 	make=gmake ;;	
esac

for prog in `which cf-build-devel.sh 2>/dev/null` \
	$HOME/indexdata/cf/bin/cf-build-devel.sh  \
	$HOME/proj/cf/bin/cf-build-devel.sh
do
   if test -x "$prog"; then
	prog=$prog
	break
   fi
done
if test -z $prog; then
   echo "cannot find cf-build-devel.sh script"
   exit 1
fi

test -n "$debug" && echo "start bootstraping in $dir"
if make=$make make_opt="$make_opt" time $prog fullcheck > cf.log 2>&1; then
    test -n "$debug" && echo "Ok"
    test -z "$debug" && rm -rf $dir
    exit 0
else
    echo "Failure, see `pwd`/cf.log"
    exit 1
fi

