var EXPORTED_SYMBOLS = ["AcceptSsl"];
const Ci = Components.interfaces;
const Cc = Components.classes;
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import("resource://indexdata/util/logging.js");
Components.utils.import('resource://indexdata/util/waitForLoad.js');
var logger = logging.getLogger();

var AcceptSsl = function () {
  this.conf = {};
  this.conf.untrusted = true;
};

AcceptSsl.prototype = new Step();
AcceptSsl.prototype.constructor = AcceptSsl;
AcceptSsl.prototype.init = function() {};

AcceptSsl.prototype.draw = function(surface) {
  Components.utils.import('resource://indexdata/util/xulHelper.js');
  var conf = this.conf;
  xulHelper.inputField(surface, this, "url", "URL", 120, {flex: 1});
  xulHelper.inputField(surface, this, "host", "Hostname", 120, {flex: 1});
  xulHelper.inputField(surface, this, "port", "Port", 120, {flex: 1});
  xulHelper.inputField(surface, this, "fingerprint", "Fingerprint",
                       120, {flex: 1});
  xulHelper.checkbox(surface, this, "untrusted", "ERROR_UNTRUSTED");
  xulHelper.checkbox(surface, this, "mismatch", "ERROR_MISMATCH");
  xulHelper.checkbox(surface, this, "time", "ERROR_TIME");
};

AcceptSsl.prototype.run = function (task) {
  let conf = this.conf; 
  let req = Cc["@mozilla.org/xmlextras/xmlhttprequest;1"]
      .createInstance(Ci.nsIXMLHttpRequest);
  // `false` makes the request synchronous
  req.open('HEAD', conf.url, false);
  try {
    req.send();
  } catch (e) {}

  let badCertService = null;
  // FF <= 19
  if (typeof Cc['@mozilla.org/security/recentbadcerts;1'] !== 'undefined') {
    badCertService = Cc['@mozilla.org/security/recentbadcerts;1']
    .getService(Ci.nsIRecentBadCertsService);
  }
  // FF >= 20
  else if (typeof Cc['@mozilla.org/security/x509certdb;1'] !== 'undefined') {

    let certDB = Cc['@mozilla.org/security/x509certdb;1']
                   .getService(Ci.nsIX509CertDB);
    if (!certDB) return null;
    // false is that we not requesting the recent bad certs from 
    // private browsing
    badCertService = certDB.getRecentBadCerts(false);
  }
  else {
    throw new StepError('Failed to get "bad cert db" service');
  }
  let cert = badCertService.getRecentBadCert(conf.host + ':' + conf.port);
  if (conf.fingerprint && conf.fingerprint !== cert.serverCert.sha1Fingerprint) {
    throw new StepError("Not overriding certificate, fingerprint doesn't match.");
  }
  let overrideService = Cc["@mozilla.org/security/certoverride;1"]
                          .getService(Ci.nsICertOverrideService);
  let override = 0;
  if (conf.untrusted) override |= Ci.nsICertOverrideService.ERROR_UNTRUSTED;
  if (conf.mismatch) override |= Ci.nsICertOverrideService.ERROR_MISMATCH;
  if (conf.time) override |= Ci.nsICertOverrideService.ERROR_TIME;
  overrideService.rememberValidityOverride(conf.host, conf.port,
    cert.serverCert, override, true);
};

AcceptSsl.prototype.getClassName = function () { return "AcceptSsl"; };
AcceptSsl.prototype.getDisplayName = function () {
  return "Accept SSL";
};
AcceptSsl.prototype.getDescription = function () {
  return "Accepts untrusted SSL certificates.";
};
AcceptSsl.prototype.getVersion = function () { return "1.0"; };

AcceptSsl.prototype.upgrade = function (confVer, curVer, conf) {
  // can't upgrade if the connector is newer than the step
  if (confVer > curVer) return false;
};
