var EXPORTED_SYMBOLS = ["ScriptSandbox"];
// ScriptSandbox_sandbox  - run a script in a sandbox
// This is intended to replace the script step, in time when
// we can afford to deprecate the old script step, and eventually
// remove it. This is not merely a new version of the script step,
// since there is no way to upgrade existing scripts automatically,
// so it can not be compatible.
Components.utils.import("resource://indexdata/runtime/core.js");
Components.utils.import('resource://indexdata/util/objHelper.js');
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/waitForLoad.js');
Components.utils.import('resource://indexdata/util/logging.js');
var logger = logging.getLogger();
var ScriptSandbox = function () {
  this.conf = {};
  this.conf['script'] = '// Start with a descriptive comment\n' +
    '// Access $.variables like this: \n' +
    '//   task.data.output.hits = [ "0" ]; \n' +
    '// (always string values, always inside an array) \n' +
    'throw new StepError("Not implemented yet");';
};
ScriptSandbox.prototype = new Step();
ScriptSandbox.prototype.constructor = ScriptSandbox;
ScriptSandbox.prototype.init = function(task) {};
ScriptSandbox.prototype.draw = function(surface) {
  var context = this;
  var scriptBox = xmlHelper.appendNode(surface, "textbox", null, {"value":this.conf["script"], "flex":"1", "multiline":"true"});
  scriptBox.addEventListener("input", function (e) {
    context.conf['script'] = scriptBox.value;
  }, false);  
  xmlHelper.appendNode(surface, "label", "JavaScript code.  Throw 'Error' on failure.");
};
ScriptSandbox.prototype.run = function (task) {
  var step = this;
  // in the engine the getPageWindow returns an IFRAME
  // so retrieve from the doc instead
  if (core.inBuilder) {
    var pageWin = task.connector.getPageWindow().contentWindow;
  } else {
    var pageWin = this.getPageDoc().defaultView;
  }
  var sb = new Components.utils.Sandbox(pageWin);
  sb.window = new XPCNativeWrapper(pageWin);
  sb.document = sb.window.document; 
  // allow the sandbox to modify the data object
  if (core.platformVersion > 17) objHelper.exposeObject(task.data);
  sb.data = task.data;
  sb.logger = new XPCNativeWrapper(logging.getLogger("execution"));
  sb.StepError = StepError;
  // backwards compatiblity with older scripts; 
  sb.task = {};
  if (core.platformVersion > 17) objHelper.exposeObject(sb.task);
  sb.task.data = sb.data;
  sb.task.output = sb.task.data.output;
  sb.task.input = sb.task.data.input;
  sb.getPageDoc = function () { return sb.document };
  // execute the script
  logger.info("Running script: " + this.renderArgs());
  var result = Components.utils.evalInSandbox(this.conf.script, sb);
};
ScriptSandbox.prototype.getClassName = function () { return "ScriptSandbox"; };
ScriptSandbox.prototype.getDisplayName = function () {
  return "Script (Sandboxed)";
};
ScriptSandbox.prototype.getDescription = function () {
  return "Executes arbitrary JavaScript code in a sandbox with the connector's data.  A tool of last resort.";
};
ScriptSandbox.prototype.getVersion = function () { return "1.0"; };
ScriptSandbox.prototype.renderArgs = function () {
  var p = this.conf.script.indexOf("\n");
  if (p == -1 ) p = 50;
  return this.conf.script.slice(0,p);
};
