var EXPORTED_SYMBOLS = ["SetPref"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');


var SetPref = function () {
  this.prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService);
  this.conf = {pref: "javascript.enabled", type: "boolean", value: "false"};
  this.prefTypes = ["string", "integer", "boolean"];
  this.storedPrefs = [
    { 'name':"Enable Javascript",
      'pref':"javascript.enabled",
      'value':true,
      'type':"boolean",},
    { 'name':"Disable Javascript",
      'pref':"javascript.enabled",
      'value':false,
      'type':"boolean",},
    { 'name':"Enable Cookies",
      'pref':"network.cookie.cookieBehavior",
      'value':0,
      'type':"integer",},
    { 'name':"Enable Cookies (same site only)",
      'pref':"network.cookie.cookieBehavior",
      'value':1,
      'type':"integer",},
    { 'name':"Disable Cookies",
      'pref':"network.cookie.cookieBehavior",
      'value':2,
      'type':"integer",},
    { 'name':'Browser useragent',
      'pref':'general.useragent.override',
      'value':'Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.2.16) Gecko/20110319 Firefox/3.6.16',
      'type':'string',},
  ];
};

SetPref.prototype = new Step();
SetPref.prototype.constructor = SetPref;

SetPref.prototype.init = function() {
  var context = this;
  this.task.addHandler("onTaskStart", function() {context.preTask()}, null);
  this.task.addHandler("onTaskFinish", function() {context.postTask()}, null);
};
SetPref.prototype.preTask = function() {
  if (this.isDisabled) return;
  this.originalValue = null;
  if (this.conf.pref && this.conf['type']) {
    var branch = this.prefs.getBranch(this.conf.pref);
    if (branch.prefHasUserValue("")) {
      switch(this.conf['type']) {
      case "integer":
        this.originalValue = branch.getIntPref("");
        break;
      case "boolean":
        this.originalValue = branch.getBoolPref("");
        break;
      case "string":
        this.originalValue = branch.getCharPref("");
        break;
      default:
        throw new StepError("Invalid preference type.");
      }
    }
  } else {
    throw new StepError("Set Preference step is not configured.");
  }
};
SetPref.prototype.postTask = function() {
  if (this.isDisabled) return;
  if (this.conf.pref && this.conf['type']) {
    var branch = this.prefs.getBranch(this.conf.pref);
    if (this.originalValue !== null) {
      switch(this.conf['type']) {
      case "integer":
        branch.setIntPref("", this.originalValue);
        break;
      case "boolean":
        branch.setBoolPref("", this.originalValue);
        break;
      case "string":
        branch.setCharPref("", this.originalValue);
        break;
      default:
        throw new StepError("Invalid preference type.");
      }
    } else {
      try {
        branch.clearUserPref("");
      } catch (e) {
        // threw exceptions in some older ff when pref had no default
      }
    }
  }
};
SetPref.prototype.draw = function(surface) {
  xmlHelper.emptyChildren(surface);
  var context=this;

  xmlHelper.appendNode(surface, "label", "Preference: ");
  var prefInput = xulHelper.inputFieldOnly(surface, this, "pref");

  xmlHelper.appendNode(surface, "label", "Value: ");
  var hbox = xmlHelper.appendNode(surface, "hbox");
  var valueInput = xulHelper.inputFieldOnly(hbox, this, "value", { flex: 1 });
  xmlHelper.appendNode(hbox, "label", "Type: ");
  var typeSelect = xulHelper.arraySelectField(hbox, this, 'type', this.prefTypes);

  xmlHelper.appendNode(surface, "label", "Commonly used preferences: ");
  var cannedSelect = xmlHelper.appendNode(surface, "menulist", null, {'label':"Select to populate the step..."});
  var cannedPop = xmlHelper.appendNode(cannedSelect, "menupopup");
  for (let i = 0; i < this.storedPrefs.length; i++) {
    xmlHelper.appendNode(cannedPop, "menuitem", null,
      {label: this.storedPrefs[i]['name'], value: i});
  }

  cannedSelect.addEventListener("select", function(e) {
    var cannedPref = context.storedPrefs[e.target.value];
    context.conf['pref']=cannedPref['pref'];
    context.conf['type']=cannedPref['type'];
    context.conf['value']=cannedPref['value'];
    prefInput.setAttribute('value', cannedPref['pref']);
    valueInput.setAttribute('value', cannedPref['value']);
    xulHelper.selectMenulistItemWithValue(typeSelect, cannedPref['type']);
  }, false);

};

SetPref.prototype.run = function (task) {
  var branch = this.prefs.getBranch(this.conf.pref);
  switch(this.conf['type']) {
  case "integer":
    branch.setIntPref("", Number(this.conf.value));
    break;
  case "boolean":
    branch.setBoolPref("", ((this.conf.value === true) || (this.conf.value === "true")));
    break;
  case "string":
    branch.setCharPref("", this.conf.value);
    break;
  default:
    throw new StepError("Invalid preference type.");
  }
};

SetPref.prototype.getClassName = function () {
  return "SetPref";
};

SetPref.prototype.getDisplayName = function () {
  return "Set preference";
};

SetPref.prototype.getDescription = function () {
  return "Provides access to the Mozilla preferences system for the environment where the task is being run.";
};

SetPref.prototype.getVersion = function () {
  return "0.2";
};

SetPref.prototype.renderArgs = function () {
  return this.conf['pref']||"";
};
