var EXPORTED_SYMBOLS = ["SetResult"];
// The so-called "constant" step

Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');
Components.utils.import('resource://indexdata/util/logging.js');

var logger = logging.getLogger();

var SetResult = function () {
  this.className = "SetResult";
  this.truncate = 80;
  this.conf = {
    constant: "",
    result: "",
    advanced: false,  // Expand $.variables
    eval: false,  // evaluate arthmetically
  };
};

// Preset xml requests
const xmlheader = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
const soapEnvelope = xmlheader +
  "<soap:Envelope xmlns=\"http://www.w3.org/2001/12/soap-envelope\" >\n" +
  "  <Header> \n" +
  "  </Header> \n" +
  "  <Body> \n" +
  "  </Body> \n" +
  "</Envelope> \n" ;
const httpHeaders = "# Additional headers for the request \n" +
  "# (Lines that start with a '#' are comments, and ignored) \n" +
  "Content-Type: application/soap+xml; charset=utf-8 \n" +
  "# Some need text/xml instead \n";
  // TODO - Add a comment about that strange X-SoapAction header

SetResult.prototype = new Step();
SetResult.prototype.constructor = SetResult;

SetResult.prototype.init = function() {
};



// TODO It would be nice if the input would not be a multi-line
// in the simple mode. But I seem not to be able to change that on the
// fly.
SetResult.prototype.draw = function(surface) {
  var context = this;
  var vb = xmlHelper.appendNode(surface, "vbox", null,
           {"flex":1,"align":"stretch"} );
  var editbox = xmlHelper.appendNode(vb, "hbox", null,
      {"flex":1,"align":"stretch"}, null);
  var captbox = xmlHelper.appendNode(editbox, "vbox" );
  xulHelper.captionField(captbox,"Constant", {width:120} );
  
  var filler1 = xmlHelper.appendNode(captbox, "hbox", null,
      {"flex":1,"align":"stretch"}, null);
  
  var advcheck = xulHelper.checkbox(captbox, this, "advanced",
        "Expand" );
  xulHelper.labelField(captbox,"{$.variables}" );
  var filler2 = xmlHelper.appendNode(captbox, "hbox", null,
      {"flex":1,"align":"stretch"}, null);
  
  var evacheck = xulHelper.checkbox(captbox, this, "eval",
        "Evaluate" );
  xulHelper.labelField(captbox,"arithmetic" );
  var filler3 = xmlHelper.appendNode(captbox, "hbox", null,
      {"flex":1,"align":"stretch"}, null);

  var constedit = xulHelper.inputField( editbox, this,
            "constant", "", 0,
            { "multiline": true, "rows": 30,
              "flex": 1, "width" : 580, "align":"stretch" } );

  var buttonbox = xmlHelper.appendNode(vb, "hbox", null, null);
  xulHelper.captionField(buttonbox, "Starting points");
  var xmlHeadButton = xmlHelper.appendNode(buttonbox, "button",
         null, {"label": "XML header", "width" : 120 }, null);
  var soapButton = xmlHelper.appendNode(buttonbox, "button",
         null, {"label": "SOAP envelope", "width" : 120 }, null);
  var headerButton = xmlHelper.appendNode(buttonbox, "button",
         null, {"label": "HTTP headers", "width" : 120 }, null);

  xulHelper.jsonPathField(surface, this, this.conf, "jsonPath", "Destination: ",
    {path:"", key:"output", append:jsonPathHelper.REPLACE});


  // Disable/enable the advanced buttons if in advanced mode,
  // and textbox is empty (otherwise they use too much screen space,
  // and clicking on them would risk overwriting usefule content)
  var checkempty = function() {
    if ( /* context.conf['advanced'] && */
         constedit.value.match(/^\s*$/) )
      buttonbox.hidden = false;
    else
      buttonbox.hidden = true;
  };

  constedit.addEventListener("input", checkempty, false);
  advcheck.addEventListener("command", checkempty, false);
  evacheck.addEventListener("command", checkempty, false);

  // TODO - For some reason the buttons don't update the step display
  // ok, it will get updated at the next input.
  xmlHeadButton.addEventListener("command", function(e) {
    constedit.value = xmlheader;
    constedit.focus();
    checkempty();
    }, false );

  soapButton.addEventListener("command", function(e) {
    constedit.value = soapEnvelope;
    constedit.focus();
    checkempty();
    }, false );

  headerButton.addEventListener("command", function(e) {
    constedit.value = httpHeaders;
    constedit.focus();
    checkempty();
  }, false );

  checkempty();

};

// Evaluate the expression inside a sandbox
function _eval(task, val) {
  logger.debug("About to evaluate '" + val + "'" );
  try {
    var sb = new Components.utils.Sandbox(task.connector.getPageUrl());
    var result = Components.utils.evalInSandbox(val, sb);
  } catch (e) {
    throw new StepError("Bad expression: " + e.message );
  }
  logger.debug("Result is  '" + result + "' " + typeof (result) );
  var typ = typeof(result);
  if ( typ != "number" && typ != "string" )
    throw new StepError("Bad expression: Return type is " + typ );
  return "" + result ; // make sure it is a string
}

SetResult.prototype.run = function (task) {
  if (!this.conf.jsonPath)
    throw new StepError("No jsonPath defined");
  var val = this.conf['constant'];
  if (this.conf['advanced'])
     val = jsonPathHelper.inlineReplace(val, task.data);
  if ( this.conf['eval'] )
    val = _eval(task,val);
  jsonPathHelper.set(this.conf.jsonPath, [val], task.data);
    // note the [] around val, we need to set an array since we don't do
    // scalars in our data model.
};

SetResult.prototype.getClassName = function () {
  return "SetResult";
};

SetResult.prototype.getDisplayName = function () {
  return "Constant";
};

SetResult.prototype.getDescription = function () {
  return "Sets a result, such as the hitcount, to a constant value. " +
  "This is useful when recognising a 'no hits' result page. " +
  "Can also be used for setting more complex things, like XML requests";
};

SetResult.prototype.getVersion = function () {
  return "1.1";  // 1.1 added arthmetic evaluation
};

SetResult.prototype.upgrade = function (confVer, curVer, conf) {
  // can't upgrade if the connector is newer than the step
  if (confVer > curVer)
    return false;
  if (confVer < 0.2) {
    conf.jsonPath = jsonPathHelper.specFromArray(["output", conf.result]);
    delete conf.result;
  }
  if ( conf.advanced == undefined )
    conf.advanced = false;
  if ( typeof(conf.eval) == "undefined" )
    conf.eval = false;
  return true;
}

SetResult.prototype.renderArgs = function () {
  if (!this.conf.jsonPath)
    return "?";
  return jsonPathHelper.displayString(this.conf.jsonPath) +
     "=" + this.conf.constant;
}

SetResult.prototype.getUsedArgs = function (  ) {
  let args = [];
  let usedArgRegex = /\{\$\.input\.(.+?)\}/g;
  let match;
  while ((match = usedArgRegex.exec(this.conf['constant'])) !== null) {
    args.push(match[1]);
  }
  return args;
};

// TODO - This is slow, getting used args every time.
// Maybe better with a regexp. Or some caching?
SetResult.prototype.capabilityFlagDefault = function ( flag ) {
  if (flag.substring(0,6) != "index-")
    return null;
  var used = this.getUsedArgs();
  for ( var a in used ) {
    var arg = used[a] ;
    if ( flag == "index-" + arg ) {
      return true;
    }
  }
  return null;
};
