var EXPORTED_SYMBOLS = ["SetValue"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');

var SetValue = function () {
  // this is only used as the init values for the display if no configuration
  // is provided, e.g when new step is added to the task
  this.conf = {
      dest: '',
      param: undefined,
      constant: undefined,
      usejp: false,
      // One of 'empty', 'fail', or 'noop'
      onempty: 'empty'
  };
};
SetValue.prototype = new Step();
SetValue.prototype.constructor = SetValue;

SetValue.prototype.init = function() {};

SetValue.prototype.draw = function(surface) {
  xmlHelper.emptyChildren(surface);
  var context=this;
  var radiogroup = xmlHelper.appendNode(surface, "radiogroup");

  // if you're setting a select element you can pick an option to populate constant
  // should you decide not to we stop listening once you move into the step pane
  var selectNode = null;
  var grabOption = function(e) {
    context.conf['constant'] = selectNode.value;
    constInput.value = selectNode.value;
    radiogroup.selectedItem = constRadio;
    selectNode.removeEventListener("change", grabOption, false);
  };
  var onNodeSelect = function(node) {
    if (node.localName.toLowerCase() == "select") {
      selectNode = node;
      node.addEventListener("change", grabOption, false);
    }
  };

  var hbox = xmlHelper.appendNode(radiogroup, "hbox", null, {align:"center"}, null);
  xmlHelper.appendNode(hbox, "label", "Form field to populate: ");
  var nodePicker = xulHelper.singleNodeField(hbox, this, "dest", onNodeSelect);

  hbox = xmlHelper.appendNode(radiogroup, "hbox", null, {align:"center"}, null);
  var argRadio = xmlHelper.appendNode(hbox, "radio", null, {"id":"argRadio", "label":"Populate with stored data:"});

  var jpField = xulHelper.jsonPathField(hbox, this, this.conf, "param");

  hbox = xmlHelper.appendNode(radiogroup, "hbox", null, {align:"center"}, null);
  var constRadio = xmlHelper.appendNode(hbox, "radio", null, {"id":"constRadio", "label":"Populate with constant:"});
  var constInput = xmlHelper.appendNode(hbox, "textbox", null, {"value":this.conf["constant"]||"", "flex":"1"});

  xmlHelper.appendNode(surface, "separator", null, {'class': 'groove'});
  xmlHelper.appendNode(surface, "caption", null, {'label':'When source empty:'});
  var emptyRadioGroup = xmlHelper.appendNode(surface, "radiogroup");
  var emptyRadios = {};
  emptyRadios.empty = xmlHelper.appendNode(emptyRadioGroup, 'radio', null, {'value':'empty', 'label':'Set empty value'});
  emptyRadios.noop = xmlHelper.appendNode(emptyRadioGroup, 'radio', null, {'value':'noop', 'label':'Do nothing'});
  emptyRadios.fail = xmlHelper.appendNode(emptyRadioGroup, 'radio', null, {'value':'fail', 'label':'Fail'});
  emptyRadioGroup.selectedItem = emptyRadios[this.conf.onempty];


  // reflect saved values
  if (context.conf.usejp) radiogroup.selectedItem = argRadio;
  else radiogroup.selectedItem = constRadio;

  var selectJP = function (e) {
    context.task.debug("Selected JSONpath.");
    context.conf.usejp = true;
    context.draw(surface);
  };

  var selectConstant = function (e) {
    context.task.debug("Selected constant.");
    context.conf.usejp = false;
    context.conf["constant"] = constInput.value;
  };

  emptyRadioGroup.addEventListener('select', function(e) {
    context.conf.onempty = e.target.value;
  }, false);

  radiogroup.addEventListener("select", function(e) {
    if (e.target.localName === "radiogroup") {
      if (!context.conf.usejp && radiogroup.selectedItem === argRadio) selectJP(e);
      else if (radiogroup.selectedItem === constRadio) selectConstant(e);
    }
  }, false);

  jpField.addEventListener("command", function (e) { radiogroup.selectedItem = argRadio; }, false);
  jpField.addEventListener("input", function (e) { radiogroup.selectedItem = argRadio; }, false);
  constInput.addEventListener("input", function (e) { radiogroup.selectedItem = constRadio; }, false);

  // if user opted not to take an option from the select node, unbind the listener
  surface.addEventListener("mouseover", function (e) {
    if (selectNode) selectNode.removeEventListener("change", grabOption, false);
  }, false);
};


SetValue.prototype.run = function (task) {
  if (!this.conf['dest']) throw new StepError("destination not specified in the configuration");
  let nodeSpec = jsonPathHelper.inlineReplaceNodeSpec(this.conf.dest, task.data);
  let dest = xmlHelper.getElementByNodeSpec(this.getPageDoc(), nodeSpec);
  if(!dest) throw new StepError("destination element not found");
  if (this.conf.usejp) {
    var val = jsonPathHelper.getFirst(this.conf.param, task.data);
    var container = this.conf['param'].key;
  } else {
    var val = this.conf.constant;
    var container = 'constant';
  }
  // 0 is the only falsy value that doesn't count as empty
  if (val || typeof val === 'number') {
    dest.value = val; 
    task.info('value set to "' + val + '" from ' + container, this);
  } else if (this.conf.onempty === 'empty') {
    dest.value = "";
    task.info('value set to an empty string, ' + container + ' is ' + val, this);
  } else if (this.conf.onempty === 'fail') {
    throw new StepError("empty value");
  } else if (this.conf.onempty === 'noop') {
    task.info('value to set is empty, continuing');
  } 
  var changeEvent = this.getPageDoc().createEvent('HTMLEvents');
  changeEvent.initEvent('change', true, true);
  dest.dispatchEvent(changeEvent);
};

SetValue.prototype.getUsedArgs = function () {
 if (this.conf.param && this.conf.param.path === "$.input")
   return [this.conf.param.key];
 else
   return [];
}

SetValue.prototype.getClassName = function () {
  return "SetValue";
};

SetValue.prototype.getDisplayName = function () {
  return "Set form value";
};

SetValue.prototype.getDescription = function () {
  return "Sets the value property of an element and fires a change event on it.";
};

SetValue.prototype.getVersion = function () {
  return "4.0";
};

SetValue.prototype.upgrade = function (confVer, curVer, conf) {
  // can't upgrade if the connector is newer than the step
  if (confVer > curVer)
    return false;
  if (confVer < 0.5) {
    if (typeof conf['dest'] == "string") {
      var oldTarget = conf['dest'];
      conf['dest'] = {};
      conf['dest']['xpath'] = oldTarget;
    }
  }
  if (confVer < 0.6) {
    if (conf.param)
      conf.param = {path: "$.input", key: conf.param};
  }
  if (confVer < 2.0) {
    if (conf.constant) conf.usejp = false;
    else conf.usejp = true;
  }
  if (confVer < 4.0) {
    if (!conf.usejp) conf.onempty = 'fail';
    else conf.onempty = 'noop';
  }
  return true;
};

SetValue.prototype.renderArgs = function () {
  if (!this.conf.dest) return "";
  else if (this.conf.usejp) return this.conf.param.path + "." + this.conf.param.key;
  else return this.conf.constant;
}


SetValue.prototype.capabilityFlagDefault = function (flag) {
    if (this.task.name === "init" && flag.substring(0, 5) == "init-") {
	var param = this.conf.param;
	//this.task.debug("set_value considering capability '" + flag + "', param = '" + param.key + "' in task '" + this.task.name + "'");
        var wanted = flag.substring(5);
        if (typeof(param) != "undefined" &&
	    param.path === "$.input" &&
	    param.key === wanted) {
            return true;
	}
        // Note, do not return false if the argument is not not there:
        // other steps may still make use of it.
    }

    // Pass up to the superclass's default implementation
    return Step.prototype.capabilityFlagDefault.call(this, flag);
}
