var EXPORTED_SYMBOLS = ["While"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/runtime/Block.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');
Components.utils.import('resource://indexdata/util/logging.js');
Components.utils.import('resource://indexdata/runtime/Conditional.js');
var logger = logging.getLogger();
var While = function () {
  this.isBreakable = true;
  this.conf = {};
  this.conf.conditions = []; // data for this.conditional, instantiated on init
};
While.prototype = new Step();
While.prototype.constructor = While;
While.prototype.init = function(task) {
  //this is ugly but we need to check if the blocks exist in that instance
  if (this.blocks.length == 0) {
    this.blocks.push(new Block(task, 'do', 'do', this));
  }
  this.conditional = new Conditional(this.conf.conditions, this.task.data);
};
While.prototype.draw = function(surface) {
  xmlHelper.appendNode(surface, "caption", "Repeat while this remains true: ");
  var condBox = xmlHelper.appendNode(surface, "vbox");
  this.conditional.draw(condBox, this);
};
While.prototype.run = function (task, block) {
  this.blocks[0].isCancelled = false;
  while (this.conditional.eval() && !this.blocks[0].isCancelled) {
    logger.debug("While about to run a block");
    this.blocks[0].run(block);
    if (this.task.isInterrupted) {
        logger.debug("while loop interrupted");
        // Tell the block to resume execution with this step, instead of the next
        this.block.nextToRun -= 1;
        return;
    }
    this.blocks[0].resetState();  // clear any possible inner loops for next 
    // iteration. Otherwise, if we have exited due to an exception, those
    // would continue where they left, and not start from scratch.
  }
};
While.prototype.getClassName = function () { return "While"; };
While.prototype.getDisplayName = function () { return "While"; };
While.prototype.getDescription = function () {
  return "Repeat block while a condition is true.";
};
While.prototype.getVersion = function () { return "1.0"; };
While.prototype.getUsedArgs = function () { return []; }
While.prototype.renderArgs = function () { 
 if (this.conditional) return String(this.conditional);
};
