var EXPORTED_SYMBOLS = ["Subject"];

Components.utils.import("resource://indexdata/util/EventList.js");
Components.utils.import("resource://indexdata/util/logging.js");

var logger = logging.getLogger();

var Subject = function (props) {
  this._eventList = new EventList();
  if (props) {
    for (var i=0; i<props.length; i++) {
      this.set(props[i], null);
    }
  }
};

Subject.prototype = {
  /**
   * Set a property that will be broadcasted to all subscribers.
  **/
  set: function (propName, value) {
    if (!this.hasOwnProperty(propName)) {
      this[propName] = value;
      //try to do some smart checks for direct updates using watch 
    } else {
      this[propName] = value;
      logger.debug("Subject: property " + propName + " modified");
      this._eventList.dispatchEvent(propName, value);
    }
  },
  /**
   * Broadcast a property (with value) or notify on event.
   **/
  notify: function (propName, args) {
    logger.debug("Subject: property " + propName + " updated");
    //if no prop found, assume a free-form callback
    if (this[propName])
      this._eventList.dispatchEvent(propName, this[propName]);
    else
      this._eventList.dispatchEvent(propName, args);
  },
  subscribe: function (propName, callback) {
    this._eventList.attachEvent(propName, callback);
  },
  unsubscribe: function (propName, callback) {
    this._eventList.detachEvent(propName, callback);
  },
  toString: function () {
    return "Subject";
  }
};
