var EXPORTED_SYMBOLS = ["helper"];
var Cc = Components.classes;
var Ci = Components.interfaces;
var helper = {
  // version checking: new major version is backwards incompatible
  // check if version A (required) is compatible with version B (available)
  // eg. for steps version from connector's step conf (A),
  // version of step in current engine (B)
  checkVersion: function (verA, verB) {
    if (typeof verA != "string") throw new Error("Required version not specified");
    if (typeof verB != "string") throw new Error("Available version not specified");
    var verAparts = verA.split(".");
    var verBparts = verB.split(".");
    var verAmajor = Number(verAparts[0]);
    var verBmajor = Number(verBparts[0]);
    if (verAmajor > verBmajor) return false;
    return true;
  },
  waitForEval: function (expression, timeout, interval, subject) {
    if (interval == undefined) { interval = 100; }
    if (timeout == undefined) { timeout = 30000; }
    var self = {};
    self.counter = 0;
    self.result = eval(expression);
    var timerCb = { notify: function () {
        self.result = eval(expression);
        self.counter += interval;
      }
    };
    var timer = Cc["@mozilla.org/timer;1"].createInstance(Ci.nsITimer);
    timer.initWithCallback(timerCb, interval,
                           Ci.nsITimer.TYPE_REPEATING_PRECISE);
    var thread = Cc["@mozilla.org/thread-manager;1"].getService().currentThread;
    while((self.result != true) && (self.counter < timeout)) {
      thread.processNextEvent(true);
    }  
    if (self.counter < timeout) { var r = true; } 
    else { var r = false; }
    timer.cancel();
    return r;
  },
  sleep: function (milliseconds) {
    var self = {};
    // We basically just call this once after the specified number of milliseconds
    var timerCb = { notify: function () { self.timeup = true; } };
    var timer = Cc["@mozilla.org/timer;1"].createInstance(Ci.nsITimer);
    timer.initWithCallback(timerCb, milliseconds,
                           Ci.nsITimer.TYPE_REPEATING_PRECISE);
    var thread = Cc["@mozilla.org/thread-manager;1"].getService().currentThread;
    // This blocks execution until our while loop condition is invalidated.  Note
    // that you must use a simple boolean expression for the loop, a function call
    // will not work.
    while(!self.timeup) thread.processNextEvent(true);
    timer.cancel();
    return true;
  }
};
